/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class ProcessForkContainerHandler
extends VMKernelEventHandler {
    public ProcessForkContainerHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Long childNSInum;
        ITmfEventField content = event.getContent();
        String machineHost = event.getTrace().getHostId();
        String childProcessName = (String)content.getField(new String[]{this.getLayout().fieldChildComm()}).getValue();
        long[] childVTIDs = new long[]{};
        ITmfEventField field = content.getField(new String[]{"vtids"});
        if (field != null) {
            childVTIDs = (long[])field.getValue();
        }
        if ((childNSInum = (Long)content.getFieldValue(Long.class, new String[]{"child_ns_inum"})) == null) {
            childNSInum = -1L;
        } else {
            ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{machineHost, "Containers", Long.toString(childNSInum)});
        }
        Long parentNSInum = (Long)content.getFieldValue(Long.class, new String[]{"parent_ns_inum"});
        Integer parentTid = ((Long)content.getField(new String[]{this.getLayout().fieldParentTid()}).getValue()).intValue();
        Integer childTid = ((Long)content.getField(new String[]{this.getLayout().fieldChildTid()}).getValue()).intValue();
        Integer parentTidNode = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss), new String[]{machineHost, parentTid.toString()});
        Integer childTidNode = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss), new String[]{machineHost, childTid.toString()});
        int quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        ss.modifyAttribute(timestamp, (Object)parentTid, quark);
        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
        ss.modifyAttribute(timestamp, (Object)childProcessName, quark);
        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Status"});
        ss.modifyAttribute(timestamp, (Object)5, quark);
        quark = ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"});
        Object syscall = ss.queryOngoing(quark);
        if (syscall != null) {
            quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
            ss.modifyAttribute(timestamp, syscall, quark);
        }
        Integer level = 0;
        Integer maxLevel = childVTIDs.length;
        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_max_level"});
        ss.modifyAttribute(timestamp, (Object)maxLevel, quark);
        long[] lArray = childVTIDs;
        int n = childVTIDs.length;
        int n2 = 0;
        while (n2 < n) {
            long vtid = lArray[n2];
            if (vtid == (long)childTid.intValue()) {
                quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_level"});
                ss.modifyAttribute(timestamp, (Object)level, quark);
                quark = ss.optQuarkRelative(parentTidNode.intValue(), new String[]{"ns_inum"});
                if (quark != -2) {
                    Object nsInum = ss.queryOngoing(quark);
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_inum"});
                    ss.modifyAttribute(timestamp, nsInum, quark);
                    if (nsInum instanceof Long) {
                        quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{machineHost, "Containers", String.valueOf((Long)nsInum)});
                        quark = FusedVMEventHandlerUtils.saveContainerThreadID(ss, quark, childTid);
                        ss.modifyAttribute(timestamp, (Object)((int)vtid), quark);
                    }
                }
            } else {
                if ((level = Integer.valueOf(level + 1)) != maxLevel - 1 || childNSInum.equals(parentNSInum)) {
                    childTidNode = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"VTID"});
                    ss.modifyAttribute(timestamp, (Object)((int)vtid), childTidNode.intValue());
                    parentTidNode = ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"VTID"});
                    Object parentVtid = ss.queryOngoing(parentTidNode.intValue());
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"VPPID"});
                    ss.modifyAttribute(timestamp, parentVtid, quark);
                    quark = ss.optQuarkRelative(parentTidNode.intValue(), new String[]{"ns_inum"});
                    if (quark == -2) {
                        value = null;
                        if (level == maxLevel - 1) {
                            value = childNSInum;
                            quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{machineHost, "Containers", Long.toString((Long)value)});
                            quark = FusedVMEventHandlerUtils.saveContainerThreadID(ss, quark, childTid);
                            ss.modifyAttribute(timestamp, (Object)((int)vtid), quark);
                        }
                        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_inum"});
                        ss.modifyAttribute(timestamp, value, quark);
                    } else {
                        value = ss.queryOngoing(quark);
                        quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_inum"});
                        ss.modifyAttribute(timestamp, value, quark);
                        if (value instanceof Long) {
                            quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{machineHost, "Containers", Long.toString((Long)value)});
                            quark = FusedVMEventHandlerUtils.saveContainerThreadID(ss, quark, childTid);
                            ss.modifyAttribute(timestamp, (Object)((int)vtid), quark);
                        }
                    }
                } else {
                    childTidNode = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"VTID"});
                    ss.modifyAttribute(timestamp, (Object)((int)vtid), childTidNode.intValue());
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"VPPID"});
                    ss.modifyAttribute(timestamp, (Object)0, quark);
                    quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_inum"});
                    ss.modifyAttribute(timestamp, (Object)childNSInum, quark);
                    int quarkContainer = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getMachinesNode(ss), new String[]{machineHost, "Containers", Long.toString(childNSInum)});
                    quark = FusedVMEventHandlerUtils.saveContainerThreadID(ss, quarkContainer, childTid);
                    ss.modifyAttribute(timestamp, (Object)((int)vtid), quark);
                    quark = ss.getQuarkRelativeAndAdd(quarkContainer, new String[]{"Parent"});
                    if (ss.queryOngoingState(quark).isNull() && parentNSInum != null) {
                        ss.modifyAttribute(ss.getStartTime(), (Object)parentNSInum, quark);
                    }
                }
                quark = ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"ns_level"});
                ss.modifyAttribute(timestamp, (Object)level, quark);
            }
            ++n2;
        }
    }
}

