/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostInfo;

public class HostThread {
    private final @NonNull HostInfo fHostId;
    private final @NonNull Long fTid;

    public HostThread(@NonNull HostInfo hostId, @NonNull Long tid) {
        this.fHostId = hostId;
        this.fTid = tid;
    }

    public @NonNull HostInfo getHostId() {
        return this.fHostId;
    }

    public @NonNull Long getTid() {
        return this.fTid;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fHostId, this.fTid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostThread o = (HostThread)obj;
        return o.fHostId.equals(this.fHostId) && o.fTid.equals(this.fTid);
    }

    public @NonNull String toString() {
        return String.format("HostThread: tid=%d, hostId=[%s]", this.fTid, this.fHostId.toString());
    }

    public void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        this.fHostId.serializeValue(buffer);
        buffer.putLong(this.fTid.longValue());
    }

    public int getSerializedValueSize() {
        int size = 0;
        size += this.fHostId.getSerializedValueSize();
        return size += 8;
    }

    public static @NonNull HostThread read(ISafeByteBufferReader buffer) {
        HostInfo hostId = HostInfo.read(buffer);
        long tid = buffer.getLong();
        return new HostThread(hostId, tid);
    }
}

