/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.DisjunctionRHS;
import org.sat4j.pb.tools.INegator;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.pb.tools.ImplicationRHS;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.pb.tools.XplainPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.Backbone;
import org.sat4j.tools.GateTranslator;

public class DependencyHelper<T, C> {
    public static final INegator NO_NEGATION = new INegator(){

        @Override
        public boolean isNegated(Object thing) {
            return false;
        }

        @Override
        public Object unNegate(Object thing) {
            return thing;
        }
    };
    public static final INegator BASIC_NEGATION = new INegator(){

        @Override
        public boolean isNegated(Object thing) {
            return thing instanceof Negation;
        }

        @Override
        public Object unNegate(Object thing) {
            return ((Negation)thing).getThing();
        }
    };
    private static final long serialVersionUID = 1L;
    private final Map<T, Integer> mapToDimacs = new HashMap<T, Integer>();
    private final Map<Integer, T> mapToDomain = new HashMap<Integer, T>();
    final Map<IConstr, C> descs = new HashMap<IConstr, C>();
    private final XplainPB xplain;
    private final GateTranslator gator;
    final IPBSolver solver;
    private INegator negator = BASIC_NEGATION;
    private ObjectiveFunction objFunction;
    private IVecInt objLiterals;
    private IVec<BigInteger> objCoefs;
    private final boolean explanationEnabled;
    private final boolean canonicalOptFunction;

    public DependencyHelper(IPBSolver solver) {
        this(solver, true);
    }

    public DependencyHelper(IPBSolver solver, boolean explanationEnabled) {
        this(solver, explanationEnabled, true);
    }

    public DependencyHelper(IPBSolver solver, boolean explanationEnabled, boolean canonicalOptFunctionEnabled) {
        if (explanationEnabled) {
            this.xplain = new XplainPB(solver);
            this.solver = this.xplain;
        } else {
            this.xplain = null;
            this.solver = solver;
        }
        this.gator = new GateTranslator((ISolver)this.solver);
        this.explanationEnabled = explanationEnabled;
        this.canonicalOptFunction = canonicalOptFunctionEnabled;
    }

    public void setNegator(INegator negator) {
        this.negator = negator;
    }

    protected int getIntValue(T thing) {
        return this.getIntValue(thing, true);
    }

    protected int getIntValue(T thing, boolean create) {
        boolean negated = this.negator.isNegated(thing);
        Object myThing = negated ? this.negator.unNegate(thing) : thing;
        Integer intValue = this.mapToDimacs.get(myThing);
        if (intValue == null) {
            if (create) {
                intValue = this.solver.nextFreeVarId(true);
                this.mapToDomain.put(intValue, myThing);
                this.mapToDimacs.put(myThing, intValue);
            } else {
                throw new IllegalArgumentException("" + myThing + " is unknown in the solver!");
            }
        }
        if (negated) {
            return -intValue.intValue();
        }
        return intValue;
    }

    public IVec<T> getSolution() {
        int[] model = this.solver.model();
        Vec toInstall = new Vec();
        if (model != null) {
            for (int i : model) {
                T obj = this.mapToDomain.get(i);
                if (obj == null) continue;
                toInstall.push(obj);
            }
        }
        return toInstall;
    }

    public Collection<T> getASolution() {
        int[] model = this.solver.model();
        ArrayList<T> toInstall = new ArrayList<T>();
        if (model != null) {
            for (int i : model) {
                if (i <= 0) continue;
                toInstall.add(this.mapToDomain.get(i));
            }
        }
        return toInstall;
    }

    public BigInteger getSolutionCost() {
        return this.objFunction.calculateDegree((RandomAccessModel)this.solver);
    }

    public boolean getBooleanValueFor(T t) {
        int dimacsValue = this.getIntValue(t, false);
        if (dimacsValue > 0) {
            return this.solver.model(dimacsValue);
        }
        return !this.solver.model(-dimacsValue);
    }

    public boolean hasASolution() throws TimeoutException {
        return this.solver.isSatisfiable();
    }

    public boolean hasASolution(IVec<T> assumps) throws TimeoutException {
        VecInt assumptions = new VecInt();
        Iterator it = assumps.iterator();
        while (it.hasNext()) {
            assumptions.push(this.getIntValue(it.next()));
        }
        return this.solver.isSatisfiable((IVecInt)assumptions);
    }

    public boolean hasASolution(Collection<T> assumps) throws TimeoutException {
        VecInt assumptions = new VecInt();
        for (T t : assumps) {
            assumptions.push(this.getIntValue(t));
        }
        return this.solver.isSatisfiable((IVecInt)assumptions);
    }

    public Set<C> why() throws TimeoutException {
        if (!this.explanationEnabled) {
            throw new UnsupportedOperationException("Explanation not enabled!");
        }
        Collection explanation = this.xplain.explain();
        TreeSet<C> ezexplain = new TreeSet<C>();
        for (IConstr constr : explanation) {
            C desc = this.descs.get(constr);
            if (desc == null) continue;
            ezexplain.add(desc);
        }
        return ezexplain;
    }

    public Set<C> why(T thing) throws TimeoutException {
        VecInt assumps = new VecInt();
        assumps.push(-this.getIntValue(thing));
        return this.why((IVecInt)assumps);
    }

    public Set<C> whyNot(T thing) throws TimeoutException {
        VecInt assumps = new VecInt();
        assumps.push(this.getIntValue(thing));
        return this.why((IVecInt)assumps);
    }

    private Set<C> why(IVecInt assumps) throws TimeoutException {
        if (this.xplain.isSatisfiable(assumps)) {
            return new TreeSet();
        }
        return this.why();
    }

    public void setTrue(T thing, C name) throws ContradictionException {
        IConstr constr = this.gator.gateTrue(this.getIntValue(thing));
        if (constr != null) {
            this.descs.put(constr, name);
        }
    }

    public void setFalse(T thing, C name) throws ContradictionException {
        IConstr constr = this.gator.gateFalse(this.getIntValue(thing));
        if (constr != null) {
            this.descs.put(constr, name);
        }
    }

    public ImplicationRHS<T, C> implication(T ... lhs) {
        VecInt clause = new VecInt();
        for (T t : lhs) {
            clause.push(-this.getIntValue(t));
        }
        return new ImplicationRHS(this, (IVecInt)clause);
    }

    public DisjunctionRHS<T, C> disjunction(T ... lhs) {
        VecInt literals = new VecInt();
        for (T t : lhs) {
            literals.push(-this.getIntValue(t));
        }
        return new DisjunctionRHS(this, (IVecInt)literals);
    }

    public void atLeast(C name, int i, T ... things) throws ContradictionException {
        VecInt literals = new VecInt();
        for (T t : things) {
            literals.push(this.getIntValue(t));
        }
        this.descs.put(this.solver.addAtLeast((IVecInt)literals, i), name);
    }

    public ImplicationNamer<T, C> atMost(int i, T ... things) throws ContradictionException {
        Vec toName = new Vec();
        VecInt literals = new VecInt();
        for (T t : things) {
            literals.push(this.getIntValue(t));
        }
        toName.push((Object)this.solver.addAtMost((IVecInt)literals, i));
        return new ImplicationNamer(this, (IVec<IConstr>)toName);
    }

    public void atMost(C name, int i, T ... things) throws ContradictionException {
        VecInt literals = new VecInt();
        for (T t : things) {
            literals.push(this.getIntValue(t));
        }
        this.descs.put(this.solver.addAtMost((IVecInt)literals, i), name);
    }

    public void clause(C name, T ... things) throws ContradictionException {
        VecInt literals = new VecInt(things.length);
        for (T t : things) {
            literals.push(this.getIntValue(t));
        }
        IConstr constr = this.gator.addClause((IVecInt)literals);
        if (constr != null) {
            this.descs.put(constr, name);
        }
    }

    public void iff(C name, T thing, T ... otherThings) throws ContradictionException {
        IConstr[] constrs;
        VecInt literals = new VecInt(otherThings.length);
        for (T t : otherThings) {
            literals.push(this.getIntValue(t));
        }
        for (IConstr constr : constrs = this.gator.iff(this.getIntValue(thing), (IVecInt)literals)) {
            if (constr == null) continue;
            this.descs.put(constr, name);
        }
    }

    public void and(C name, T thing, T ... otherThings) throws ContradictionException {
        IConstr[] constrs;
        VecInt literals = new VecInt(otherThings.length);
        for (T t : otherThings) {
            literals.push(this.getIntValue(t));
        }
        for (IConstr constr : constrs = this.gator.and(this.getIntValue(thing), (IVecInt)literals)) {
            if (constr == null) continue;
            this.descs.put(constr, name);
        }
    }

    public void or(C name, T thing, T ... otherThings) throws ContradictionException {
        IConstr[] constrs;
        VecInt literals = new VecInt(otherThings.length);
        for (T t : otherThings) {
            literals.push(this.getIntValue(t));
        }
        for (IConstr constr : constrs = this.gator.or(this.getIntValue(thing), (IVecInt)literals)) {
            if (constr == null) continue;
            this.descs.put(constr, name);
        }
    }

    public void halfOr(C name, T thing, T ... otherThings) throws ContradictionException {
        IConstr[] constrs;
        VecInt literals = new VecInt(otherThings.length);
        for (T t : otherThings) {
            literals.push(this.getIntValue(t));
        }
        for (IConstr constr : constrs = this.gator.halfOr(this.getIntValue(thing), (IVecInt)literals)) {
            if (constr == null) continue;
            this.descs.put(constr, name);
        }
    }

    public void ifThenElse(C name, T thing, T conditionThing, T thenThing, T elseThing) throws ContradictionException {
        IConstr[] constrs;
        for (IConstr constr : constrs = this.gator.ite(this.getIntValue(thing), this.getIntValue(conditionThing), this.getIntValue(thenThing), this.getIntValue(elseThing))) {
            if (constr == null) continue;
            this.descs.put(constr, name);
        }
    }

    public void setObjectiveFunction(WeightedObject<T> ... wobj) {
        this.createObjectivetiveFunctionIfNeeded(wobj.length);
        for (WeightedObject<T> wo : wobj) {
            this.addProperly(wo.thing, wo.getWeight());
        }
    }

    private void addProperly(T thing, BigInteger weight) {
        int index;
        int lit = this.getIntValue(thing);
        if (this.canonicalOptFunction && (index = this.objLiterals.indexOf(lit)) != -1) {
            this.objCoefs.set(index, (Object)((BigInteger)this.objCoefs.get(index)).add(weight));
            if (((BigInteger)this.objCoefs.get(index)).equals(BigInteger.ZERO)) {
                this.objLiterals.delete(index);
                this.objCoefs.delete(index);
            }
        } else {
            this.objLiterals.push(lit);
            this.objCoefs.push((Object)weight);
        }
    }

    private void createObjectivetiveFunctionIfNeeded(int n) {
        if (this.objFunction == null) {
            this.objLiterals = new VecInt(n);
            this.objCoefs = new Vec(n);
            this.objFunction = new ObjectiveFunction(this.objLiterals, this.objCoefs);
            this.solver.setObjectiveFunction(this.objFunction);
        }
    }

    public void addToObjectiveFunction(T thing, int weight) {
        this.addToObjectiveFunction(thing, BigInteger.valueOf(weight));
    }

    public void addToObjectiveFunction(T thing, BigInteger weight) {
        this.createObjectivetiveFunctionIfNeeded(20);
        this.addProperly(thing, weight);
    }

    public void atLeast(C name, BigInteger degree, WeightedObject<T> ... wobj) throws ContradictionException {
        VecInt literals = new VecInt(wobj.length);
        Vec coeffs = new Vec(wobj.length);
        for (WeightedObject<T> wo : wobj) {
            literals.push(this.getIntValue(wo.thing));
            coeffs.push((Object)wo.getWeight());
        }
        this.descs.put(this.solver.addPseudoBoolean((IVecInt)literals, (IVec<BigInteger>)coeffs, true, degree), name);
    }

    public void atMost(C name, BigInteger degree, WeightedObject<T> ... wobj) throws ContradictionException {
        VecInt literals = new VecInt(wobj.length);
        Vec coeffs = new Vec(wobj.length);
        for (WeightedObject<T> wo : wobj) {
            literals.push(this.getIntValue(wo.thing));
            coeffs.push((Object)wo.getWeight());
        }
        this.descs.put(this.solver.addPseudoBoolean((IVecInt)literals, (IVec<BigInteger>)coeffs, false, degree), name);
    }

    public void atMost(C name, int degree, WeightedObject<T> ... wobj) throws ContradictionException {
        this.atMost(name, BigInteger.valueOf(degree), wobj);
    }

    public void stopSolver() {
        this.solver.expireTimeout();
    }

    public void stopExplanation() {
        if (!this.explanationEnabled) {
            throw new UnsupportedOperationException("Explanation not enabled!");
        }
        this.xplain.cancelExplanation();
    }

    public void discard(IVec<T> things) throws ContradictionException {
        VecInt literals = new VecInt(things.size());
        Iterator it = things.iterator();
        while (it.hasNext()) {
            literals.push(-this.getIntValue(it.next()));
        }
        this.solver.addBlockingClause((IVecInt)literals);
    }

    public void discardSolutionsWithObjectiveValueGreaterThan(long value) throws ContradictionException {
        ObjectiveFunction obj = this.solver.getObjectiveFunction();
        VecInt literals = new VecInt(obj.getVars().size());
        obj.getVars().copyTo((IVecInt)literals);
        Vec coeffs = new Vec(obj.getCoeffs().size());
        obj.getCoeffs().copyTo((IVec)coeffs);
        this.solver.addPseudoBoolean((IVecInt)literals, (IVec<BigInteger>)coeffs, false, BigInteger.valueOf(value));
    }

    public String getObjectiveFunction() {
        ObjectiveFunction obj = this.solver.getObjectiveFunction();
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < obj.getVars().size(); ++i) {
            stb.append(obj.getCoeffs().get(i) + (obj.getVars().get(i) > 0 ? " " : "~") + this.mapToDomain.get(Math.abs(obj.getVars().get(i))) + " ");
        }
        return stb.toString();
    }

    public int getNumberOfVariables() {
        return this.mapToDimacs.size();
    }

    public int getNumberOfConstraints() {
        return this.descs.size();
    }

    public Map<Integer, T> getMappingToDomain() {
        return this.mapToDomain;
    }

    public Object not(T thing) {
        return new Negation(thing);
    }

    public IPBSolver getSolver() {
        if (this.explanationEnabled) {
            return (IPBSolver)this.xplain.decorated();
        }
        return this.solver;
    }

    public void reset() {
        this.mapToDimacs.clear();
        this.mapToDomain.clear();
        this.descs.clear();
        this.solver.reset();
        if (this.objLiterals != null) {
            this.objLiterals.clear();
            this.objCoefs.clear();
        }
    }

    public void impliedBy(Collection<T> assumptions, Collection<T> satisfied, Collection<T> falsified) throws TimeoutException {
        VecInt assump = new VecInt(assumptions.size());
        for (T thing : assumptions) {
            assump.push(this.getIntValue(thing));
        }
        IVecInt implied = Backbone.instance().compute((ISolver)this.solver, (IVecInt)assump);
        for (int p : implied) {
            if (p > 0) {
                satisfied.add(this.mapToDomain.get(p));
                continue;
            }
            falsified.add(this.mapToDomain.get(-p));
        }
    }

    private static final class Negation {
        private final Object thing;

        Negation(Object thing) {
            this.thing = thing;
        }

        Object getThing() {
            return this.thing;
        }

        public String toString() {
            return "-" + this.thing;
        }
    }
}

