/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonFieldClassAliasMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.BlobDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasTargetParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.dynamicarray.DynamicLengthArrayParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.dynamicstring.DynamicLengthStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.floatingpoint.FloatDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.staticarray.StaticLengthArrayParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.staticstring.StaticLengthStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.StringDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TypeAliasParser
extends AbstractScopedCommonTreeParser {
    private static final String SIGNED = "signed";
    private static final String VARINT = "varint";
    public static final TypeAliasParser INSTANCE = new TypeAliasParser();

    private TypeAliasParser() {
    }

    @Override
    public IDeclaration parse(ICTFMetadataNode typealias, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        String aliasString;
        IDeclaration targetDeclaration;
        DeclarationScope scope;
        block65: {
            CTFTrace trace;
            ICTFMetadataNode alias;
            ICTFMetadataNode target;
            List<ICTFMetadataNode> children;
            block62: {
                block63: {
                    JsonPrimitive jPrimitive;
                    if (!(param instanceof Param)) {
                        throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
                    }
                    scope = ((Param)param).fDeclarationScope;
                    children = typealias.getChildren();
                    target = null;
                    alias = null;
                    targetDeclaration = null;
                    trace = ((Param)param).fTrace;
                    aliasString = null;
                    if (!(typealias instanceof JsonStructureFieldMemberMetadataNode)) break block62;
                    JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)typealias;
                    String type = typealias.getType();
                    JsonObject fieldClass = null;
                    if (member.getFieldClass().isJsonObject()) {
                        fieldClass = member.getFieldClass().getAsJsonObject();
                        aliasString = member.getName();
                        type = member.getType();
                    } else if (member.getFieldClass().isJsonPrimitive() && (jPrimitive = member.getFieldClass().getAsJsonPrimitive()).isString()) {
                        String fieldClassAlias = jPrimitive.getAsString();
                        ICTFMetadataNode root = member;
                        while (root.getParent() != null) {
                            root = root.getParent();
                        }
                        for (ICTFMetadataNode node : root.getChildren()) {
                            JsonFieldClassAliasMetadataNode aliasMetadataNode;
                            if (!(node instanceof JsonFieldClassAliasMetadataNode) || !(aliasMetadataNode = (JsonFieldClassAliasMetadataNode)node).getName().equals(fieldClassAlias)) continue;
                            fieldClass = aliasMetadataNode.getFieldClass();
                            aliasString = aliasMetadataNode.getName();
                            JsonElement typeMember = fieldClass.get("type");
                            if (typeMember == null || !typeMember.isJsonPrimitive()) break;
                            type = typeMember.getAsString();
                            break;
                        }
                        if (fieldClass == null) {
                            throw new ParseException("no previously occurring field class alias named '" + fieldClassAlias + "'");
                        }
                    }
                    if (fieldClass == null) break block63;
                    if (type.isEmpty() && fieldClass.isJsonObject()) {
                        type = fieldClass.get("type").getAsString();
                    }
                    switch (type) {
                        case "fixed-length-unsigned-integer": {
                            fieldClass.addProperty(SIGNED, Boolean.valueOf(false));
                            fieldClass.addProperty(VARINT, Boolean.valueOf(false));
                            targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
                            break block65;
                        }
                        case "fixed-length-signed-integer": {
                            fieldClass.addProperty(SIGNED, Boolean.valueOf(true));
                            fieldClass.addProperty(VARINT, Boolean.valueOf(false));
                            targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
                            break block65;
                        }
                        case "variable-length-unsigned-integer": {
                            fieldClass.addProperty(SIGNED, Boolean.valueOf(false));
                            fieldClass.addProperty(VARINT, Boolean.valueOf(true));
                            targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
                            break block65;
                        }
                        case "variable-length-signed-integer": {
                            fieldClass.addProperty(SIGNED, Boolean.valueOf(true));
                            fieldClass.addProperty(VARINT, Boolean.valueOf(true));
                            targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
                            break block65;
                        }
                        case "static-length-blob": {
                            targetDeclaration = BlobDeclarationParser.INSTANCE.parse(typealias, null);
                            break block65;
                        }
                        case "null-terminated-string": {
                            targetDeclaration = StringDeclarationParser.INSTANCE.parse(typealias, null);
                            break block65;
                        }
                        case "variant": {
                            targetDeclaration = VariantParser.INSTANCE.parse(typealias, new VariantParser.Param(trace, scope));
                            break block65;
                        }
                        case "fixed-length-unsigned-enumeration": {
                            targetDeclaration = EnumParser.INSTANCE.parse(typealias, new EnumParser.Param(trace, scope));
                            break block65;
                        }
                        case "dynamic-length-string": {
                            targetDeclaration = DynamicLengthStringParser.INSTANCE.parse(typealias, new DynamicLengthStringParser.Param(trace));
                            break block65;
                        }
                        case "static-length-string": {
                            targetDeclaration = StaticLengthStringParser.INSTANCE.parse(typealias, new StaticLengthStringParser.Param(trace));
                            break block65;
                        }
                        case "static-length-array": {
                            targetDeclaration = StaticLengthArrayParser.INSTANCE.parse(typealias, new StaticLengthArrayParser.Param(trace, scope));
                            break block65;
                        }
                        case "dynamic-length-array": {
                            targetDeclaration = DynamicLengthArrayParser.INSTANCE.parse(typealias, new DynamicLengthArrayParser.Param(trace, scope));
                            break block65;
                        }
                        case "structure": {
                            targetDeclaration = StructParser.INSTANCE.parse(typealias, new StructParser.Param(trace, null, scope));
                            break block65;
                        }
                        case "fixed-length-floating-point-number": {
                            targetDeclaration = FloatDeclarationParser.INSTANCE.parse(typealias, new FloatDeclarationParser.Param(trace));
                            break block65;
                        }
                        case "variable-length-floating-point-number": {
                            targetDeclaration = FloatDeclarationParser.INSTANCE.parse(typealias, new FloatDeclarationParser.Param(trace));
                            break block65;
                        }
                        default: {
                            throw new ParseException("Invalid field class: " + type);
                        }
                    }
                }
                throw new ParseException("field-class property is not a JSON object or JSON string");
            }
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[113].equals(type)) {
                    target = child;
                    continue;
                }
                if (CTFParser.tokenNames[112].equals(type)) {
                    alias = child;
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
            targetDeclaration = TypeAliasTargetParser.INSTANCE.parse(target, new TypeAliasTargetParser.Param(trace, scope));
            if (targetDeclaration instanceof VariantDeclaration && ((VariantDeclaration)targetDeclaration).isTagged()) {
                throw new ParseException("Typealias of untagged variant is not permitted");
            }
            aliasString = TypeAliasAliasParser.INSTANCE.parse(alias, null);
            if (scope.lookupType(aliasString) != null) {
                throw new ParseException("Type has already been defined: " + aliasString);
            }
        }
        scope.registerType(aliasString, targetDeclaration);
        return targetDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

