/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.validate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.IValidatorGroupListener;
import org.eclipse.wst.validation.ValidationState;

public class ValidatorGroupListener
implements IValidatorGroupListener {
    Map fDiagnosticMap = new HashMap();
    private static final Object LOCK = new Object();
    private static final boolean _debug = false;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.fDiagnosticMap != null && !this.fDiagnosticMap.isEmpty()) {
            Object[] paths = this.fDiagnosticMap.keySet().toArray();
            int i = 0;
            while (i < paths.length) {
                Logger.log(4, "Leaked model: " + paths[i]);
                this.validationFinishing((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)paths[i]), (IProgressMonitor)new NullProgressMonitor(), null);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validationFinishing(IResource resource, IProgressMonitor monitor, ValidationState state) {
        if (resource.getType() != 1) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            IPath path = resource.getFullPath();
            ValidationModelReference ref = (ValidationModelReference)this.fDiagnosticMap.get(path);
            if (ref != null && --ref.count == 0) {
                this.fDiagnosticMap.remove(path);
                if (ref.model != null) {
                    ref.model.releaseFromRead();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validationStarting(IResource resource, IProgressMonitor monitor, ValidationState state) {
        block9: {
            try {
                if (monitor == null || monitor.isCanceled()) break block9;
                if (resource.getType() != 1) {
                    return;
                }
                Object object = LOCK;
                synchronized (object) {
                    IPath path = resource.getFullPath();
                    ValidationModelReference ref = (ValidationModelReference)this.fDiagnosticMap.get(path);
                    if (ref != null) {
                        ++ref.count;
                    } else {
                        IStructuredModel model;
                        IModelManager modelManager = StructuredModelManager.getModelManager();
                        if (modelManager != null && (model = modelManager.getModelForRead((IFile)resource)) != null) {
                            this.fDiagnosticMap.put(resource.getFullPath(), new ValidationModelReference(model));
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    private class ValidationModelReference {
        IStructuredModel model;
        int count;

        public ValidationModelReference(IStructuredModel model) {
            this.model = model;
            this.count = 1;
        }
    }
}

