/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class SeriesLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final String ID = "ID";
    public static final String VISIBLE = "Visible";
    public static final String VISIBLE_IN_LEGEND = "Visible In Legend";
    public static final String COLOR = "Color";
    public static final String DESCRIPTION = "Description";
    public static final String MAPPING_STATUS = "Mapping Status";
    public static final int INDEX_ID = 0;
    public static final int INDEX_MAPPING_STATUS = 1;
    public static final int INDEX_VISIBLE = 2;
    public static final int INDEX_VISIBLE_IN_LEGEND = 3;
    private BaseChart baseChart = null;
    public static final String[] TITLES = new String[]{"ID", "Mapping Status", "Visible", "Visible In Legend", "Color", "Description"};
    public static final int[] BOUNDS = new int[]{24, 30, 30, 30, 30, 200};

    public static Color getColor(ISeriesSettings seriesSettings) {
        Color color = null;
        if (seriesSettings instanceof IBarSeriesSettings) {
            color = ((IBarSeriesSettings)seriesSettings).getBarColor();
        } else if (seriesSettings instanceof ILineSeriesSettings) {
            color = ((ILineSeriesSettings)seriesSettings).getLineColor();
        } else if (seriesSettings instanceof IScatterSeriesSettings) {
            color = ((IScatterSeriesSettings)seriesSettings).getSymbolColor();
        } else if (seriesSettings instanceof ICircularSeriesSettings) {
            color = ((ICircularSeriesSettings)seriesSettings).getSliceColor();
        }
        return color;
    }

    public static void setColor(ISeriesSettings seriesSettings, Color color) {
        if (color != null) {
            if (seriesSettings instanceof IBarSeriesSettings) {
                ((IBarSeriesSettings)seriesSettings).setBarColor(color);
            } else if (seriesSettings instanceof ILineSeriesSettings) {
                ((ILineSeriesSettings)seriesSettings).setLineColor(color);
            } else if (seriesSettings instanceof IScatterSeriesSettings) {
                ((IScatterSeriesSettings)seriesSettings).setSymbolColor(color);
            } else if (seriesSettings instanceof ICircularSeriesSettings) {
                ((ICircularSeriesSettings)seriesSettings).setSliceColor(color);
            }
        }
    }

    public void setBaseChart(BaseChart baseChart) {
        this.baseChart = baseChart;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ISeries) {
            ISeriesSettings seriesSettings;
            ISeries series = (ISeries)element;
            Image seriesMarker = ResourceSupport.getImage("seriesMarker.gif");
            Image checked = ResourceSupport.getImage("checked.gif");
            Image unchecked = ResourceSupport.getImage("unchecked.gif");
            Image mappings = ResourceSupport.getImage("mappings.gif");
            if (columnIndex == 0) {
                return seriesMarker;
            }
            if (columnIndex == 2) {
                return series.isVisible() ? checked : unchecked;
            }
            if (columnIndex == 3) {
                return series.isVisibleInLegend() ? checked : unchecked;
            }
            if (columnIndex == 1 && this.baseChart != null && (seriesSettings = SeriesMapper.get(series, this.baseChart)) != null) {
                return mappings;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ISeries) {
            ISeries series = (ISeries)element;
            switch (columnIndex) {
                case 0: {
                    text = series.getId();
                    break;
                }
                case 1: {
                    text = "";
                    break;
                }
                case 2: {
                    text = "";
                    break;
                }
                case 3: {
                    text = "";
                    break;
                }
                case 4: {
                    text = "";
                    break;
                }
                case 5: {
                    text = series.getDescription();
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }
}

