/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public final class FilesystemTools {
    @Deprecated
    private FilesystemTools() {
        throw new IllegalArgumentException("Not intended to be instantiated");
    }

    public static File createFolder(File folder) throws IOException {
        if (!folder.exists()) {
            if (folder.mkdirs()) {
                return folder;
            }
            throw new IOException(String.format("Could not create folder '%s' on file system", folder.toString()));
        }
        if (folder.isFile()) {
            throw new IOException(String.format("A file with the name '%s' already exists", folder.toString()));
        }
        return folder;
    }

    public static File createFile(File file) throws IOException {
        if (file.exists()) {
            throw new IOException(String.format("A file with the name '%s' already exists", file.toString()));
        }
        FilesystemTools.createFolder(file.getParentFile());
        if (file.createNewFile()) {
            return file;
        }
        throw new IOException(String.format("Could not create file '%s'", file.toString()));
    }

    public static void deleteFile(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (NoSuchFileException noSuchFileException) {}
            } else {
                throw new IOException(String.format("Cannot delete file '%s' as it is a folder", file));
            }
        }
    }

    public static void deleteFolder(File folder) throws IOException {
        if (folder.exists()) {
            if (folder.isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        FilesystemTools.deleteFile(file);
                    } else {
                        FilesystemTools.deleteFolder(file);
                    }
                    ++n2;
                }
                Files.delete(folder.toPath());
            } else {
                throw new IOException(String.format("Cannot delete folder '%s' as it is a file", folder));
            }
        }
    }

    public static String openFileSelectionDialog(final File dialogRoot, final int mode, final String title) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            public String runWithTry() throws Throwable {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), mode);
                if (title != null) {
                    dialog.setText(title);
                }
                dialog.setFilterPath(dialogRoot.getAbsolutePath());
                return dialog.open();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    public static String openFolderSelectionDialog(final File dialogRoot, final String title, final String message) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            public String runWithTry() throws Throwable {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                if (title != null) {
                    dialog.setText(title);
                }
                if (message != null) {
                    dialog.setMessage(message);
                }
                dialog.setFilterPath(dialogRoot.getAbsolutePath());
                return dialog.open();
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    public static String[] findFiles(Pattern regExp, File root, boolean recursive) throws IOException {
        if (!root.isDirectory()) {
            throw new IOException(String.format("'%s' is a file, not a folder", root));
        }
        ArrayList<String> result = new ArrayList<String>();
        HashSet<File> toVisit = new HashSet<File>();
        toVisit.add(root);
        do {
            File container = (File)toVisit.iterator().next();
            toVisit.remove(container);
            File[] files = container.listFiles();
            if (files == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    if (regExp.matcher(child.getName()).matches()) {
                        result.add(child.getAbsolutePath());
                    }
                } else if (recursive && child.isDirectory()) {
                    toVisit.add(child);
                }
                ++n2;
            }
        } while (!toVisit.isEmpty());
        return result.toArray(new String[0]);
    }

    public static void zip(final Path sourceFilePath, Path zipFilePath) throws IOException {
        try {
            URI uri = URIUtil.fromString((String)("jar:file:" + zipFilePath.toUri().getPath()));
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", zipFilePath.toFile().exists() ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
            Throwable throwable = null;
            Object var5_7 = null;
            try (final FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
                final Path root = fileSystem.getPath("/", new String[0]);
                if (Files.isDirectory(sourceFilePath, new LinkOption[0])) {
                    Files.walkFileTree(sourceFilePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Path relativePath = sourceFilePath.relativize(file);
                            Path zipEntry = fileSystem.getPath(root.toString(), relativePath.toString());
                            Files.copy(file, zipEntry, StandardCopyOption.REPLACE_EXISTING);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            Path relativePath = sourceFilePath.relativize(dir);
                            Path zipDirectory = fileSystem.getPath(root.toString(), relativePath.toString());
                            if (Files.notExists(zipDirectory, new LinkOption[0])) {
                                Files.createDirectories(zipDirectory, new FileAttribute[0]);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                } else {
                    if (Files.notExists(root, new LinkOption[0])) {
                        Files.createDirectories(root, new FileAttribute[0]);
                    }
                    Path destinationPath = fileSystem.getPath(root.toString(), sourceFilePath.getFileName().toString());
                    Files.copy(sourceFilePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static void unzip(Path zipFilePath, final Path targetDirectoryPath) throws IOException {
        URI uri = URI.create("jar:file:" + zipFilePath.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", Boolean.FALSE.toString());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
            Path root = fileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetFile = Paths.get(targetDirectoryPath.toString(), file.toString());
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetDirectory = Paths.get(targetDirectoryPath.toString(), dir.toString());
                    if (Files.notExists(targetDirectory, new LinkOption[0])) {
                        Files.createDirectory(targetDirectory, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] getChecksum(InputStream input) throws IOException {
        try {
            int readBytes;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(input, digest);
            byte[] buffer = new byte[8192];
            while ((readBytes = digestInputStream.read(buffer)) > 0) {
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("MD5 digest not found", e);
        }
    }
}

