/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumBodyParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumContainerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EnumParser
extends AbstractScopedCommonTreeParser {
    public static final EnumParser INSTANCE = new EnumParser();

    private EnumParser() {
    }

    @Override
    public EnumDeclaration parse(ICTFMetadataNode theEnum, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        Param parameter = (Param)param;
        DeclarationScope scope = parameter.fCurrentScope;
        CTFTrace trace = parameter.fTrace;
        EnumDeclaration enumDeclaration = null;
        String enumName = null;
        ICTFMetadataNode enumBody = null;
        IntegerDeclaration containerTypeDeclaration = null;
        if (theEnum instanceof JsonStructureFieldMemberMetadataNode) {
            JsonStructureFieldMemberMetadataNode jsonEnum = (JsonStructureFieldMemberMetadataNode)theEnum;
            enumName = jsonEnum.getName();
            enumBody = jsonEnum;
            containerTypeDeclaration = IntegerDeclarationParser.INSTANCE.parse(jsonEnum, new IntegerDeclarationParser.Param(trace));
        } else {
            List<ICTFMetadataNode> children = theEnum.getChildren();
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[95].equals(type)) {
                    ICTFMetadataNode enumNameIdentifier = child.getChild(0);
                    enumName = enumNameIdentifier.getText();
                    continue;
                }
                if (CTFParser.tokenNames[92].equals(type)) {
                    enumBody = child;
                    continue;
                }
                if (CTFParser.tokenNames[93].equals(type)) {
                    containerTypeDeclaration = EnumContainerParser.INSTANCE.parse(child, new EnumContainerParser.Param(trace, scope));
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        if (containerTypeDeclaration == null) {
            IDeclaration decl;
            if (enumName != null) {
                scope.setName(enumName);
                EnumDeclaration enumDecl = scope.lookupEnumRecursive(enumName);
                if (enumDecl != null) {
                    return enumDecl;
                }
            }
            if ((decl = scope.lookupTypeRecursive("int")) == null) {
                throw new ParseException("enum container type implicit and type int not defined");
            }
            if (!(decl instanceof IntegerDeclaration)) {
                throw new ParseException("enum container type implicit and type int not an integer");
            }
            containerTypeDeclaration = (IntegerDeclaration)decl;
        }
        if (enumBody != null) {
            if (enumName != null && scope.lookupEnum(enumName) != null) {
                throw new ParseException("enum " + enumName + " already defined");
            }
            enumDeclaration = new EnumDeclaration(containerTypeDeclaration);
            EnumBodyParser.INSTANCE.parse(enumBody, new EnumBodyParser.Param(enumDeclaration));
            if (enumName != null) {
                scope.registerEnum(enumName, enumDeclaration);
            }
        } else if (enumName != null) {
            enumDeclaration = scope.lookupEnumRecursive(enumName);
            if (enumDeclaration == null) {
                throw new ParseException("enum " + enumName + " is not defined");
            }
        } else {
            throw new ParseException("enum with no name and no body");
        }
        return enumDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fCurrentScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope currentScope) {
            this.fTrace = trace;
            this.fCurrentScope = currentScope;
        }
    }
}

