/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class MergeRequestsHandler
extends KernelEventHandler {
    private final InputOutputStateProvider fStateProvider;

    public MergeRequestsHandler(IKernelAnalysisEventLayout layout, InputOutputStateProvider sp) {
        super(layout);
        this.fStateProvider = sp;
    }

    @Override
    public void handleEvent(@NonNull ITmfStateSystemBuilder ss, @NonNull ITmfEvent event) throws AttributeNotFoundException {
        Request mergedRequest;
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        int phydisk = ((Long)content.getField(new String[]{this.getLayout().fieldBlockDeviceId()}).getValue()).intValue();
        Long baseRequestSector = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldBlockRqSector()}).getValue()));
        Long mergedRequestSector = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldBlockNextRqSector()}).getValue()));
        DiskWriteModel disk = this.fStateProvider.getDisk(phydisk);
        Request baseRequest = disk.getWaitingRequest(baseRequestSector);
        if (baseRequest == null) {
            baseRequest = new Request(disk, baseRequestSector, IoOperationType.OTHER);
        }
        if ((mergedRequest = disk.getWaitingRequest(mergedRequestSector)) == null) {
            mergedRequest = new Request(disk, mergedRequestSector, IoOperationType.OTHER);
        }
        disk.mergeRequests(ts, baseRequest, mergedRequest);
    }
}

