/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.TmfEdgeState;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.Messages;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;

public class OSEdgeContextState
implements ITmfEdgeContextState {
    OSEdgeContextEnum fContextState = OSEdgeContextEnum.DEFAULT;
    private static EnumMap<OSEdgeContextEnum, Map<String, Object>> fStyles = new EnumMap(OSEdgeContextEnum.class);

    static {
        fStyles.put(OSEdgeContextEnum.NO_EDGE, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Unknown), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)64, (int)59, (int)51), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.EPS, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Unknown), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)64, (int)59, (int)51), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.UNKNOWN, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Unknown), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)64, (int)59, (int)51), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.DEFAULT, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Unknown), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)64, (int)59, (int)51), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.RUNNING, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Running), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)51, (int)153, (int)0), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.BLOCKED, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Blocked), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)220, (int)20, (int)60), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.INTERRUPTED, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Interrupted), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)255, (int)220, (int)0), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.PREEMPTED, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Preempted), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)200, (int)100, (int)0), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.TIMER, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Timer), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)51, (int)102, (int)153), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.NETWORK, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_Network), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)255, (int)155, (int)255), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.USER_INPUT, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_UserInput), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)90, (int)1, (int)1), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.BLOCK_DEVICE, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_BlockDevice), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)102, (int)0, (int)204), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
        fStyles.put(OSEdgeContextEnum.IPI, (Map<String, Object>)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.TmfEdge_IPI), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)102, (int)102, (int)204), (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f), (Object)"style-group", (Object)String.valueOf(Messages.TmfEdge_GroupBlocked)));
    }

    public OSEdgeContextState(OSEdgeContextEnum contextStateEnum) {
        this.fContextState = contextStateEnum;
    }

    public OSEdgeContextState(int code) {
        this.fContextState = (OSEdgeContextEnum)this.deserialize(code);
    }

    public OSEdgeContextState(TmfEdge.EdgeType type) {
        switch (type) {
            case BLOCKED: {
                this.fContextState = OSEdgeContextEnum.BLOCKED;
                break;
            }
            case BLOCK_DEVICE: {
                this.fContextState = OSEdgeContextEnum.BLOCK_DEVICE;
                break;
            }
            case EPS: {
                this.fContextState = OSEdgeContextEnum.EPS;
                break;
            }
            case DEFAULT: {
                this.fContextState = OSEdgeContextEnum.DEFAULT;
                break;
            }
            case INTERRUPTED: {
                this.fContextState = OSEdgeContextEnum.INTERRUPTED;
                break;
            }
            case IPI: {
                this.fContextState = OSEdgeContextEnum.IPI;
                break;
            }
            case NETWORK: {
                this.fContextState = OSEdgeContextEnum.NETWORK;
                break;
            }
            case PREEMPTED: {
                this.fContextState = OSEdgeContextEnum.PREEMPTED;
                break;
            }
            case RUNNING: {
                this.fContextState = OSEdgeContextEnum.RUNNING;
                break;
            }
            case TIMER: {
                this.fContextState = OSEdgeContextEnum.TIMER;
                break;
            }
            case USER_INPUT: {
                this.fContextState = OSEdgeContextEnum.USER_INPUT;
                break;
            }
            default: {
                this.fContextState = OSEdgeContextEnum.UNKNOWN;
            }
        }
    }

    public TmfEdge.EdgeType getOldEdgeType() {
        switch (this.fContextState) {
            case BLOCKED: {
                return TmfEdge.EdgeType.BLOCKED;
            }
            case BLOCK_DEVICE: {
                return TmfEdge.EdgeType.BLOCK_DEVICE;
            }
            case DEFAULT: {
                return TmfEdge.EdgeType.DEFAULT;
            }
            case EPS: {
                return TmfEdge.EdgeType.EPS;
            }
            case INTERRUPTED: {
                return TmfEdge.EdgeType.INTERRUPTED;
            }
            case IPI: {
                return TmfEdge.EdgeType.IPI;
            }
            case NETWORK: {
                return TmfEdge.EdgeType.NETWORK;
            }
            case NO_EDGE: {
                return TmfEdge.EdgeType.DEFAULT;
            }
            case PREEMPTED: {
                return TmfEdge.EdgeType.PREEMPTED;
            }
            case RUNNING: {
                return TmfEdge.EdgeType.RUNNING;
            }
            case TIMER: {
                return TmfEdge.EdgeType.TIMER;
            }
            case USER_INPUT: {
                return TmfEdge.EdgeType.USER_INPUT;
            }
        }
        return TmfEdge.EdgeType.UNKNOWN;
    }

    @Override
    public TmfEdgeState getEdgeState() {
        switch (this.fContextState) {
            case NO_EDGE: 
            case UNKNOWN: 
            case RUNNING: 
            case INTERRUPTED: 
            case PREEMPTED: 
            case TIMER: 
            case USER_INPUT: 
            case BLOCK_DEVICE: 
            case IPI: {
                return TmfEdgeState.PASS;
            }
            case BLOCKED: 
            case NETWORK: {
                return TmfEdgeState.BLOCK;
            }
        }
        return TmfEdgeState.UNKNOWN;
    }

    @Override
    public boolean isMatchable() {
        return this.fContextState == OSEdgeContextEnum.NETWORK;
    }

    @Override
    public Map<String, Object> getStyles() {
        return fStyles.getOrDefault((Object)this.fContextState, fStyles.get((Object)OSEdgeContextEnum.DEFAULT));
    }

    public static Map<String, Object> getStyles(OSEdgeContextEnum contextState) {
        return fStyles.getOrDefault((Object)contextState, fStyles.get((Object)OSEdgeContextEnum.DEFAULT));
    }

    @Override
    public void setContextEnum(Enum<?> contextState) {
        this.fContextState = (OSEdgeContextEnum)contextState;
    }

    @Override
    public Enum<?> getContextEnum() {
        return this.fContextState;
    }

    @Override
    public int serialize() {
        return this.fContextState.ordinal();
    }

    @Override
    public Enum<?> deserialize(int code) {
        return OSEdgeContextEnum.fromValue(code);
    }

    public static enum OSEdgeContextEnum {
        NO_EDGE(0),
        EPS(1),
        UNKNOWN(2),
        DEFAULT(3),
        RUNNING(4),
        BLOCKED(5),
        INTERRUPTED(6),
        PREEMPTED(7),
        TIMER(8),
        NETWORK(9),
        USER_INPUT(10),
        BLOCK_DEVICE(11),
        IPI(12);

        private int code;
        private static Map<Integer, OSEdgeContextEnum> fMap;

        static {
            fMap = new HashMap<Integer, OSEdgeContextEnum>();
            fMap.put(0, NO_EDGE);
            fMap.put(1, EPS);
            fMap.put(2, UNKNOWN);
            fMap.put(3, DEFAULT);
            fMap.put(4, RUNNING);
            fMap.put(5, BLOCKED);
            fMap.put(6, INTERRUPTED);
            fMap.put(7, PREEMPTED);
            fMap.put(8, TIMER);
            fMap.put(9, NETWORK);
            fMap.put(10, USER_INPUT);
            fMap.put(11, BLOCK_DEVICE);
            fMap.put(12, IPI);
        }

        private OSEdgeContextEnum(int code) {
            this.code = code;
        }

        public static OSEdgeContextEnum fromValue(int code) {
            return fMap.getOrDefault(code, UNKNOWN);
        }

        public int serialize() {
            return this.code;
        }
    }
}

