/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.hyperlink;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMNamedNodeMapImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.hyperlink.CatalogEntryHyperlink;
import org.eclipse.wst.xml.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.wst.xml.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLHyperlinkDetector
extends AbstractHyperlinkDetector {
    private final String NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";
    private final String SCHEMA_LOCATION = "schemaLocation";
    private final String XMLNS = "xmlns";
    private final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";

    private IHyperlink createHyperlink(String uriString, IRegion hyperlinkRegion, IDocument document, Node node) {
        Object link = null;
        ICatalogEntry entry = this.getCatalogEntry(uriString);
        if (entry != null) {
            link = new CatalogEntryHyperlink(hyperlinkRegion, entry);
        } else {
            File systemFile = this.getFileFromUriString(uriString);
            if (systemFile != null) {
                String systemPath = systemFile.getPath();
                IFile file = this.getFile(systemPath);
                link = file != null ? new WorkspaceFileHyperlink(hyperlinkRegion, file) : new ExternalFileHyperlink(hyperlinkRegion, systemFile);
            }
        }
        return link;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document;
        Node currentNode;
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>(0);
        if (region != null && textViewer != null && (currentNode = this.getCurrentNode(document = textViewer.getDocument(), region.getOffset())) != null) {
            IRegion hyperlinkRegion;
            IHyperlink hyperlink;
            String uriString = null;
            if (currentNode.getNodeType() == 10) {
                uriString = this.getURIString(currentNode, document, region);
            } else if (currentNode.getNodeType() == 1) {
                Attr currentAttr = this.getCurrentAttrNode(currentNode, region.getOffset());
                if (!(currentAttr == null || (uriString = this.getURIString(currentAttr, document, region)) != null && this.isValidURI(uriString))) {
                    currentAttr = null;
                }
                if (currentAttr == null && (currentAttr = this.getLinkableAttr((Element)currentNode)) != null) {
                    uriString = this.getURIString(currentAttr, document, region);
                }
                currentNode = currentAttr;
            }
            if (uriString != null && currentNode != null && this.isValidURI(uriString) && (hyperlink = this.createHyperlink(uriString, hyperlinkRegion = this.getHyperlinkRegion(currentNode), document, currentNode)) != null) {
                hyperlinks.add(hyperlink);
            }
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private String getBaseLocation(IDocument document) {
        String result = null;
        IStructuredModel sModel = null;
        try {
            IFile file;
            Path path;
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null && (path = new Path(result = sModel.getBaseLocation())).segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
                String baseLocation = null;
                if (file.getLocation() != null) {
                    baseLocation = file.getLocation().toString();
                }
                if (baseLocation == null && file.getLocationURI() != null) {
                    baseLocation = file.getLocationURI().toString();
                }
                if (baseLocation == null) {
                    baseLocation = file.getFullPath().toString();
                }
                result = baseLocation;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return result;
    }

    private CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration ed = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (mq != null) {
            ed = mq.getCMElementDeclaration(element);
        }
        return ed;
    }

    private Attr getCurrentAttrNode(Node node, int offset) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(offset) && node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                IndexedRegion attRegion = (IndexedRegion)attrs.item(i);
                if (attRegion.contains(offset)) {
                    return (Attr)attrs.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    private Node getCurrentNode(IDocument document, int offset) {
        IndexedRegion inode = null;
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null && (inode = sModel.getIndexedRegion(offset)) == null) {
                inode = sModel.getIndexedRegion(offset - 1);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        if (inode instanceof Node) {
            return (Node)inode;
        }
        return null;
    }

    private IFile getFile(String fileString) {
        IFile file = null;
        if (fileString != null) {
            Path filePath = new Path(fileString);
            if (filePath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath).exists()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].exists()) {
                    file = files[i];
                }
                ++i;
            }
        }
        return file;
    }

    private File getFileFromUriString(String uriString) {
        File file = null;
        try {
            file = new File(uriString);
            URI uri = new URI(uriString);
            file = new File(uri);
        }
        catch (Exception exception) {}
        return file;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region hyperRegion = null;
        if (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 10) {
                IDOMNode docNode = (IDOMNode)node;
                hyperRegion = new Region(docNode.getStartOffset(), docNode.getEndOffset() - docNode.getStartOffset());
            } else if (nodeType == 2) {
                IDOMAttr att = (IDOMAttr)node;
                int regOffset = att.getValueRegionStartOffset();
                ITextRegion valueRegion = att.getValueRegion();
                if (valueRegion != null) {
                    int regLength = valueRegion.getTextLength();
                    String attValue = att.getValueRegionText();
                    if (StringUtils.isQuoted((String)attValue)) {
                        ++regOffset;
                        regLength -= 2;
                    }
                    hyperRegion = new Region(regOffset, regLength);
                }
            }
        }
        return hyperRegion;
    }

    private Attr getLinkableAttr(Element element) {
        CMElementDeclaration ed = this.getCMElementDeclaration(element);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr att = (Attr)attrs.item(i);
            if (this.isLinkableAttr(att, ed)) {
                return att;
            }
            ++i;
        }
        return null;
    }

    private String getLocationHint(Element elementNode, String namespaceURI) {
        Attr schemaLocNode = elementNode.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocNode != null) {
            StringTokenizer st = new StringTokenizer(schemaLocNode.getValue());
            while (st.hasMoreTokens()) {
                String systemId;
                String publicId = st.hasMoreTokens() ? st.nextToken() : null;
                String string = systemId = st.hasMoreTokens() ? st.nextToken() : null;
                if (!namespaceURI.equalsIgnoreCase(publicId)) continue;
                return systemId;
            }
        }
        return null;
    }

    private String getURIString(Node node, IDocument document, IRegion region) {
        String resolvedURI = null;
        String baseLoc = null;
        String publicId = null;
        String systemId = null;
        short nodeType = node.getNodeType();
        if (nodeType == 10) {
            baseLoc = this.getBaseLocation(document);
            publicId = ((DocumentType)node).getPublicId();
            systemId = ((DocumentType)node).getSystemId();
        } else if (nodeType == 2) {
            Attr attrNode = (Attr)node;
            String attrName = attrNode.getName();
            String attrValue = attrNode.getValue();
            if ((attrValue = StringUtils.strip((String)attrValue)) != null && attrValue.length() > 0) {
                baseLoc = this.getBaseLocation(document);
                String prefix = DOMNamespaceHelper.getPrefix((String)attrName);
                String unprefixedName = DOMNamespaceHelper.getUnprefixedName((String)attrName);
                if ("xmlns".equals(prefix) || "xmlns".equals(unprefixedName)) {
                    publicId = attrValue;
                    systemId = this.getLocationHint(attrNode.getOwnerElement(), publicId);
                    if (systemId == null) {
                        systemId = attrValue;
                    }
                } else if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attrNode)) && "schemaLocation".equals(unprefixedName)) {
                    String attrText = "";
                    int relativeOffset = -1;
                    if (node instanceof IDOMNode) {
                        relativeOffset = region.getOffset() - ((IDOMNode)node).getStartOffset();
                        try {
                            attrText = document.get(((IDOMNode)node).getStartOffset(), ((IDOMNode)node).getLength());
                        }
                        catch (BadLocationException e) {
                            Logger.logException(e);
                        }
                    }
                    StringTokenizer st = new StringTokenizer(attrValue);
                    while (st.hasMoreTokens()) {
                        publicId = st.nextToken();
                        systemId = st.hasMoreTokens() ? st.nextToken() : null;
                        int startOffset = -1;
                        int endOffset = -1;
                        if (publicId != null) {
                            startOffset = attrText.indexOf(publicId);
                            endOffset = systemId != null ? attrText.indexOf(systemId) + systemId.length() : attrText.indexOf(publicId) + publicId.length();
                        }
                        if (startOffset > relativeOffset || relativeOffset > endOffset) {
                            continue;
                        }
                        break;
                    }
                } else {
                    systemId = attrValue;
                }
            }
        }
        resolvedURI = this.resolveURI(baseLoc, publicId, systemId);
        return resolvedURI;
    }

    private boolean isLinkableAttr(Attr attr, CMElementDeclaration cmElement) {
        String attrName = attr.getName();
        String prefix = DOMNamespaceHelper.getPrefix((String)attrName);
        String unprefixedName = DOMNamespaceHelper.getUnprefixedName((String)attrName);
        if ("xmlns".equals(prefix) || "xmlns".equals(unprefixedName)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attr)) && ("schemaLocation".equals(unprefixedName) || "noNamespaceSchemaLocation".equals(unprefixedName))) {
            return true;
        }
        if (cmElement != null) {
            CMNamedNodeMap attrDecls = cmElement.getAttributes();
            CMNamedNodeMapImpl allAttributes = new CMNamedNodeMapImpl(attrDecls);
            List nodes = ModelQueryUtil.getModelQuery((Document)attr.getOwnerDocument()).getAvailableContent(attr.getOwnerElement(), cmElement, 1);
            int k = 0;
            while (k < nodes.size()) {
                CMNode cmnode = (CMNode)nodes.get(k);
                if (cmnode.getNodeType() == 2) {
                    allAttributes.put(cmnode);
                }
                ++k;
            }
            attrDecls = allAttributes;
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(attrName);
            if (attrDecl != null && attrDecl.getAttrType() != null && "URI".equals(attrDecl.getAttrType().getDataTypeName())) {
                return true;
            }
        }
        return false;
    }

    private boolean isValidURI(String uriString) {
        boolean isValid = false;
        if (this.getCatalogEntry(uriString) != null) {
            isValid = true;
        } else {
            File file = this.getFileFromUriString(uriString);
            if (file != null) {
                isValid = file.isFile();
            }
        }
        return isValid;
    }

    private ICatalogEntry getCatalogEntry(String uriString) {
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (defaultCatalog != null) {
            ICatalogEntry[] entries = defaultCatalog.getCatalogEntries();
            int entry = 0;
            while (entry < entries.length) {
                if (uriString.equals(entries[entry].getKey()) || uriString.equals(entries[entry].getURI())) {
                    return entries[entry];
                }
                ++entry;
            }
            INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
            int nextCatalog = 0;
            while (nextCatalog < nextCatalogs.length) {
                ICatalog catalog = nextCatalogs[nextCatalog].getReferencedCatalog();
                ICatalogEntry[] entries2 = catalog.getCatalogEntries();
                int entry2 = 0;
                while (entry2 < entries2.length) {
                    if (uriString.equals(entries2[entry2].getKey()) || uriString.equals(entries2[entry2].getURI())) {
                        return entries2[entry2];
                    }
                    ++entry2;
                }
                ++nextCatalog;
            }
        }
        return null;
    }

    private String resolveURI(String baseLocation, String publicId, String systemId) {
        if (baseLocation == null && publicId == null && systemId == null) {
            return null;
        }
        return URIResolverPlugin.createResolver().resolve(baseLocation, publicId, systemId);
    }
}

