/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Objects;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class Requirement
implements IRequirement,
IMemberProvider {
    public static final String MEMBER_FILTER = "filter";
    public static final String MEMBER_MIN = "min";
    public static final String MEMBER_MAX = "max";
    public static final String MEMBER_GREEDY = "greedy";
    public static final String MEMBER_MATCH = "match";
    protected final IMatchExpression<IInstallableUnit> filter;
    protected final IMatchExpression<IInstallableUnit> matchExpression;
    protected final boolean greedy;
    protected final int min;
    protected final int max;
    protected final String description;

    public Requirement(IMatchExpression<IInstallableUnit> requirement, IMatchExpression<IInstallableUnit> filter, int min, int max, boolean greedy, String description) {
        this.matchExpression = requirement;
        this.filter = filter;
        this.min = min;
        this.max = max;
        this.greedy = greedy;
        this.description = description;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.matchExpression);
        Object[] params = this.matchExpression.getParameters();
        if (params.length > 0) {
            result.append(" (");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(params[i]);
                ++i;
            }
            result.append(')');
        }
        this.appendDetails(result);
        return result.toString();
    }

    protected void appendDetails(StringBuilder builder) {
        Object[] parameters;
        if (this.min != 1) {
            builder.append(", min=").append(this.min);
        }
        if (this.max != 1) {
            builder.append(", max=").append(this.max);
        }
        if (!this.greedy) {
            builder.append(", greedy=").append(this.greedy);
        }
        if (this.filter != null && (parameters = this.filter.getParameters()) != null && parameters.length > 0 && parameters[0] != null) {
            builder.append(", filter=").append(parameters[0]);
        }
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.matchExpression, this.min, this.max, this.greedy, this.matchExpression);
    }

    public boolean equals(Object obj) {
        IRequirement other;
        if (this == obj) {
            return true;
        }
        return obj instanceof IRequirement && Objects.equals(this.filter, (other = (IRequirement)obj).getFilter()) && this.min == other.getMin() && this.max == other.getMax() && this.greedy == other.isGreedy() && this.matchExpression.equals(other.getMatches());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public IMatchExpression<IInstallableUnit> getFilter() {
        return this.filter;
    }

    @Override
    public IMatchExpression<IInstallableUnit> getMatches() {
        return this.matchExpression;
    }

    @Override
    public boolean isMatch(IInstallableUnit candidate) {
        return this.matchExpression.isMatch(candidate);
    }

    @Override
    public Object getMember(String memberName) {
        return switch (memberName) {
            case MEMBER_FILTER -> this.filter;
            case MEMBER_MIN -> this.min;
            case MEMBER_MAX -> this.max;
            case MEMBER_GREEDY -> this.greedy;
            case MEMBER_MATCH -> this.matchExpression;
            default -> throw new IllegalArgumentException("No such member: " + memberName);
        };
    }
}

