/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.ui.tests.fetch;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfilesReader;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.remote.ui.tests.fetch.AbstractRemoteImportProfilesIOTest;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class RemoteImportProfilesReaderTest
extends AbstractRemoteImportProfilesIOTest {
    private static final Path INVALID_EMPTY_PROFILE_PATH = new Path("resources/invalid_profile_empty_profile.xml");
    private static final Path INVALID_MISSING_FILES_PROFILE_PATH = new Path("resources/invalid_profile_missing_files.xml");
    private static final Path INVALID_MISSING_ROOT_PROFILE_PATH = new Path("resources/invalid_profile_missing_root.xml");

    @Test
    public void testValidateValid() throws Exception {
        RemoteImportProfilesReaderTest.validatePath((IPath)VALID_PROFILE_PATH);
    }

    @Test(expected=SAXException.class)
    public void testValidateInvalidEmptyProfile() throws Exception {
        RemoteImportProfilesReaderTest.validatePath((IPath)INVALID_EMPTY_PROFILE_PATH);
    }

    @Test(expected=SAXException.class)
    public void testValidateInvalidMissingFiles() throws Exception {
        RemoteImportProfilesReaderTest.validatePath((IPath)INVALID_MISSING_FILES_PROFILE_PATH);
    }

    @Test(expected=SAXException.class)
    public void testValidateInvalidMissingRoot() throws Exception {
        RemoteImportProfilesReaderTest.validatePath((IPath)INVALID_MISSING_ROOT_PROFILE_PATH);
    }

    @Test
    public void testLoadElements() throws Exception {
        TracePackageElement[] elements = RemoteImportProfilesReaderTest.loadElementsFromPath((IPath)VALID_PROFILE_PATH);
        Assert.assertEquals((String)"profile element count", (long)2L, (long)elements.length);
        TracePackageElement element = elements[0];
        Assert.assertTrue((boolean)(element instanceof RemoteImportProfileElement));
        RemoteImportProfileElement profileElement = (RemoteImportProfileElement)element;
        Assert.assertEquals((Object)"myProfile", (Object)profileElement.getProfileName());
        Image image = profileElement.getImage();
        Assert.assertNotNull((Object)image);
        image.dispose();
        Assert.assertEquals((String)"profile children count", (long)2L, (long)profileElement.getChildren().length);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(RemoteImportConnectionNodeElement.class, profileElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof RemoteImportConnectionNodeElement));
        RemoteImportConnectionNodeElement nodeElement = (RemoteImportConnectionNodeElement)element;
        Assert.assertEquals((Object)"myhost", (Object)nodeElement.getName());
        Assert.assertEquals((Object)"ssh://user@127.0.0.1:22", (Object)nodeElement.getURI());
        image = nodeElement.getImage();
        Assert.assertNotNull((Object)image);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(RemoteImportTraceGroupElement.class, nodeElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof RemoteImportTraceGroupElement));
        RemoteImportTraceGroupElement traceGroupElement = (RemoteImportTraceGroupElement)element;
        Assert.assertEquals((Object)"/home/user/traces/test/test_with_lttng", (Object)traceGroupElement.getRootImportPath());
        Assert.assertTrue((boolean)traceGroupElement.isRecursive());
        image = traceGroupElement.getImage();
        Assert.assertNotNull((Object)image);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(TracePackageTraceElement.class, traceGroupElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof TracePackageTraceElement));
        TracePackageTraceElement traceElement = (TracePackageTraceElement)element;
        Assert.assertEquals((Object)"test.log.(group1)", (Object)traceElement.getText());
        Assert.assertEquals((Object)"org.eclipse.tracecompass.tmf.remote.ui.test.tracetype1", (Object)traceElement.getTraceType());
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(TracePackageFilesElement.class, traceElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof TracePackageFilesElement));
        TracePackageFilesElement traceFilesElement = (TracePackageFilesElement)element;
        Assert.assertEquals((Object)".*test\\.log\\.(\\d+)", (Object)traceFilesElement.getFileName());
        image = traceFilesElement.getImage();
        Assert.assertNotNull((Object)image);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(RemoteImportConnectionNodeElement.class, profileElement.getChildren()).get(1);
        Assert.assertTrue((boolean)(element instanceof RemoteImportConnectionNodeElement));
        nodeElement = (RemoteImportConnectionNodeElement)element;
        Assert.assertEquals((Object)"myhost3", (Object)nodeElement.getName());
        Assert.assertEquals((Object)"ssh://user@127.0.0.1:22", (Object)nodeElement.getURI());
        image = nodeElement.getImage();
        Assert.assertNotNull((Object)image);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(RemoteImportTraceGroupElement.class, nodeElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof RemoteImportTraceGroupElement));
        traceGroupElement = (RemoteImportTraceGroupElement)element;
        Assert.assertEquals((Object)"/home", (Object)traceGroupElement.getRootImportPath());
        Assert.assertFalse((boolean)traceGroupElement.isRecursive());
        image = traceGroupElement.getImage();
        Assert.assertNotNull((Object)image);
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(TracePackageTraceElement.class, traceGroupElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof TracePackageTraceElement));
        traceElement = (TracePackageTraceElement)element;
        Assert.assertEquals((Object)"", (Object)traceElement.getText());
        Assert.assertEquals((Object)"trace.type", (Object)traceElement.getTraceType());
        element = (TracePackageElement)RemoteImportProfilesReaderTest.getElementOfClass(TracePackageFilesElement.class, traceElement.getChildren()).get(0);
        Assert.assertTrue((boolean)(element instanceof TracePackageFilesElement));
        traceFilesElement = (TracePackageFilesElement)element;
        Assert.assertEquals((Object)".*", (Object)traceFilesElement.getFileName());
        image = traceFilesElement.getImage();
        Assert.assertNotNull((Object)image);
    }

    private static void validatePath(IPath profilePath) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream inputStream = new FileInputStream(RemoteImportProfilesReaderTest.getProfilesFile(profilePath));){
            RemoteImportProfilesReader.validate((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static TracePackageElement[] loadElementsFromPath(IPath profilePath) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream inputStream = new FileInputStream(RemoteImportProfilesReaderTest.getProfilesFile(profilePath));){
            return RemoteImportProfilesReader.loadElementsFromProfiles((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T extends TracePackageElement> List<T> getElementOfClass(Class<T> clazz, TracePackageElement[] elements) {
        ArrayList<TracePackageElement> result = new ArrayList<TracePackageElement>();
        TracePackageElement[] tracePackageElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement element = tracePackageElementArray[n2];
            if (clazz.isInstance(element)) {
                result.add((TracePackageElement)clazz.cast(element));
            }
            ++n2;
        }
        return result;
    }
}

