/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol;

import java.util.ArrayList;
import java.util.Collection;

public enum PcapProtocol {
    PCAP("Packet Capture", "pcap", Layer.LAYER_0, false),
    ETHERNET_II("Ethernet II", "eth", Layer.LAYER_2, true),
    IPV4("Internet Protocol Version 4", "ipv4", Layer.LAYER_3, true),
    IPV6("Internet Protocol Version 6", "ipv6", Layer.LAYER_3, true),
    TCP("Transmission Control Protocol", "tcp", Layer.LAYER_4, true),
    UDP("User Datagram Protocol", "udp", Layer.LAYER_4, true),
    UNKNOWN("Payload", "???", Layer.LAYER_7, false);

    private final String fName;
    private final String fShortName;
    private final Layer fLayer;
    private final boolean fSupportsStream;

    private PcapProtocol(String name, String shortName, Layer layer, boolean supportsStream) {
        this.fName = name;
        this.fShortName = shortName;
        this.fLayer = layer;
        this.fSupportsStream = supportsStream;
    }

    public String getName() {
        return this.fName;
    }

    public String getShortName() {
        return this.fShortName;
    }

    public Layer getLayer() {
        return this.fLayer;
    }

    public boolean supportsStream() {
        return this.fSupportsStream;
    }

    public static Collection<PcapProtocol> getProtocolsOnLayer(Layer layer) {
        ArrayList<PcapProtocol> protocolsOnLayer = new ArrayList<PcapProtocol>();
        PcapProtocol[] pcapProtocolArray = PcapProtocol.values();
        int n = pcapProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            PcapProtocol p = pcapProtocolArray[n2];
            if (p.getLayer() == layer) {
                protocolsOnLayer.add(p);
            }
            ++n2;
        }
        return protocolsOnLayer;
    }

    public static enum Layer {
        LAYER_0,
        LAYER_1,
        LAYER_2,
        LAYER_3,
        LAYER_4,
        LAYER_5,
        LAYER_6,
        LAYER_7;

    }
}

