/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.text.rules;

import java.util.Locale;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;

public class StructuredTextPartitionerForXML
extends StructuredTextPartitioner
implements IStructuredTextPartitioner {
    private static final String[] configuredContentTypes = new String[]{"org.eclipse.wst.xml.XML_DEFAULT", "org.eclipse.wst.xml.XML_CDATA", "org.eclipse.wst.xml.XML_PI", "org.eclipse.wst.xml.XML_DECL", "org.eclipse.wst.xml.XML_COMMENT", "org.eclipse.wst.xml.dtd.internal_subset", "org.eclipse.wst.xml.PROCESSING_INSTRUCTION:"};

    protected void setInternalPartition(int offset, int length, String type) {
        super.setInternalPartition(offset, length, type);
    }

    protected void initLegalContentTypes() {
        this.fSupportedTypes = configuredContentTypes;
    }

    public String getPartitionType(ITextRegion region, int offset) {
        Object result = null;
        if (region.getType() == "XML_COMMENT_TEXT") {
            result = "org.eclipse.wst.xml.XML_COMMENT";
        } else if (region.getType() == "XML_CDATA_TEXT") {
            result = "org.eclipse.wst.xml.XML_CDATA";
        } else if (region.getType() == "XML_PI_CONTENT") {
            IStructuredDocumentRegion docRegion = this.fStructuredDocument.getRegionAtCharacterOffset(offset);
            ITextRegion name = docRegion.getRegionAtCharacterOffset(docRegion.getStartOffset() + region.getStart() - 1);
            result = "org.eclipse.wst.xml.PROCESSING_INSTRUCTION:" + docRegion.getText(name).toUpperCase(Locale.ENGLISH);
        } else {
            result = region.getType() == "XML_PI_OPEN" ? "org.eclipse.wst.xml.XML_PI" : (region.getType() == "XML_DOCTYPE_DECLARATION" ? "org.eclipse.wst.xml.XML_DECL" : (region.getType() == "XML_DOCTYPE_INTERNAL_SUBSET" ? "org.eclipse.wst.xml.dtd.internal_subset" : super.getPartitionType(region, offset)));
        }
        return result;
    }

    protected String getPartitionType(ForeignRegion region, int offset) {
        return super.getPartitionType(region, offset);
    }

    public String getPartitionTypeBetween(IStructuredDocumentRegion previousNode, IStructuredDocumentRegion nextNode) {
        return super.getPartitionTypeBetween(previousNode, nextNode);
    }

    public String getDefaultPartitionType() {
        return "org.eclipse.wst.xml.XML_DEFAULT";
    }

    public IDocumentPartitioner newInstance() {
        StructuredTextPartitionerForXML instance = new StructuredTextPartitionerForXML();
        return instance;
    }

    public static String[] getConfiguredContentTypes() {
        return configuredContentTypes;
    }

    protected String getPartitionFromBlockedText(ITextRegion region, int offset, String result) {
        String newResult = result;
        if (region.getType() == "BLOCK_TEXT") {
            newResult = region instanceof ForeignRegion ? this.getPartitionType((ForeignRegion)region, offset) : (region instanceof ForeignRegion ? this.getPartitionType((ForeignRegion)region, offset) : this.getUnknown());
        }
        return newResult;
    }

    protected boolean doParserSpecificCheck(int offset, boolean partitionFound, IStructuredDocumentRegion sdRegion, IStructuredDocumentRegion previousStructuredDocumentRegion, ITextRegion next, ITextRegion previousStart) {
        if (previousStart != null && previousStart.getType() == "XML_TAG_OPEN" && next.getType() == "XML_END_TAG_OPEN") {
            ITextRegion previousName = previousStructuredDocumentRegion.getRegionAtCharacterOffset(previousStructuredDocumentRegion.getEndOffset(previousStart));
            ITextRegion nextName = sdRegion.getRegionAtCharacterOffset(sdRegion.getEndOffset(next));
            if (previousName != null && nextName != null && previousName.getType() == "XML_TAG_NAME" && nextName.getType() == "XML_TAG_NAME") {
                this.setInternalPartition(offset, 0, this.getPartitionTypeBetween(previousStructuredDocumentRegion, sdRegion));
                partitionFound = true;
            }
        }
        return partitionFound;
    }
}

