/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlOutputEntryCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYProviderFactory;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlXYViewCu
implements IDataDrivenCompilationUnit {
    private final List<TmfXmlOutputEntryCu> fEntries;
    private final Set<String> fAnalysisIds;

    private TmfXmlXYViewCu(List<TmfXmlOutputEntryCu> entriesCu, Set<String> analysisIds) {
        this.fEntries = entriesCu;
        this.fAnalysisIds = analysisIds;
    }

    @Override
    public DataDrivenXYProviderFactory generate() {
        List<DataDrivenOutputEntry> entries = this.fEntries.stream().map(TmfXmlOutputEntryCu::generate).collect(Collectors.toList());
        return new DataDrivenXYProviderFactory(entries, this.fAnalysisIds);
    }

    public static @Nullable TmfXmlXYViewCu compile(AnalysisCompilationData compilationData, Element viewElement) {
        Set<String> analysisIds = TmfXmlUtils.getViewAnalysisIds(viewElement);
        List<Element> entries = TmfXmlUtils.getChildElements(viewElement, "entry");
        ArrayList<TmfXmlOutputEntryCu> entriesCu = new ArrayList<TmfXmlOutputEntryCu>();
        for (Element entry : entries) {
            TmfXmlOutputEntryCu entryCu = TmfXmlOutputEntryCu.compile(compilationData, entry);
            if (entryCu == null) continue;
            entriesCu.add(entryCu);
        }
        return new TmfXmlXYViewCu(entriesCu, analysisIds);
    }
}

