/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.internal.ChartLayoutData;
import org.eclipse.swtchart.internal.Messages;
import org.eclipse.swtchart.internal.Util;

public class Title
implements ITitle,
PaintListener {
    protected Chart chart;
    protected String text;
    private Color foreground;
    private Font font;
    private StyleRange[] styleRanges;
    private final TextLayout textLayout;
    protected boolean isVisible;
    private final Font defaultFont;
    private Rectangle bounds;
    private ChartLayoutData layoutData;
    private static final int DEFAULT_FONT_SIZE = 13;
    private static final int DEFAULT_FOREGROUND = 9;
    private static final String DEFAULT_TEXT = "";

    public Title(Chart parent) {
        this.chart = parent;
        this.text = DEFAULT_TEXT;
        this.isVisible = true;
        this.defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 13, 1);
        this.textLayout = new TextLayout((Device)Display.getDefault());
        this.bounds = new Rectangle(0, 0, 0, 0);
        this.font = this.defaultFont;
        this.setForeground(Display.getDefault().getSystemColor(9));
        parent.addPaintListener(this);
    }

    @Override
    public void setText(String text) {
        String title = text == null ? this.getDefaultText() : text;
        this.textLayout.setText(title);
        this.text = title;
        this.chart.updateLayout();
    }

    protected String getDefaultText() {
        return DEFAULT_TEXT;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            this.font = this.defaultFont;
        } else {
            if (font.isDisposed()) {
                throw new IllegalArgumentException(Messages.getString("DISPOSED_FONT_GIVEN"));
            }
            this.font = font;
        }
        this.chart.updateLayout();
    }

    @Override
    public Font getFont() {
        if (this.font.isDisposed()) {
            this.font = this.defaultFont;
        }
        return this.font;
    }

    @Override
    public void setForeground(Color color) {
        if (color == null) {
            this.foreground = Display.getDefault().getSystemColor(9);
        } else {
            if (color.isDisposed()) {
                throw new IllegalArgumentException(Messages.getString("DISPOSED_COLOR_GIVEN"));
            }
            this.foreground = color;
        }
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setStyleRanges(StyleRange[] ranges) {
        this.styleRanges = ranges;
        if (this.styleRanges != null) {
            StyleRange[] styleRangeArray = this.styleRanges;
            int n = this.styleRanges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                if (range != null) {
                    this.textLayout.setStyle((TextStyle)range, range.start, range.start + range.length);
                }
                ++n2;
            }
        }
        this.chart.updateLayout();
    }

    @Override
    public StyleRange[] getStyleRanges() {
        return this.styleRanges;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.isVisible == isVisible) {
            return;
        }
        this.isVisible = isVisible;
        this.chart.updateLayout();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isHorizontal() {
        return true;
    }

    public void updateLayoutData() {
        int height;
        int width;
        if (this.isVisible() && !this.text.trim().equals(DEFAULT_TEXT)) {
            if (this.styleRanges == null) {
                Point p = Util.getExtentInGC(this.getFont(), this.text);
                width = p.x;
                height = p.y;
            } else {
                Rectangle r = this.textLayout.getBounds();
                width = r.width;
                height = r.height;
            }
        } else {
            width = 0;
            height = 0;
        }
        if (this.isHorizontal()) {
            this.setLayoutData(new ChartLayoutData(width, height));
        } else {
            this.setLayoutData(new ChartLayoutData(height, width));
        }
    }

    public void setLayoutData(ChartLayoutData layoutData) {
        this.layoutData = layoutData;
    }

    public ChartLayoutData getLayoutData() {
        return this.layoutData;
    }

    public void dispose() {
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
        if (!this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        this.chart.removePaintListener(this);
    }

    public void paintControl(PaintEvent e) {
        if (this.text == null || this.text.equals(DEFAULT_TEXT) || !this.isVisible) {
            return;
        }
        Font oldFont = e.gc.getFont();
        Color oldForeground = this.getForeground();
        e.gc.setFont(this.getFont());
        e.gc.setForeground(this.getForeground());
        if (this.isHorizontal()) {
            this.drawHorizontalTitle(e.gc);
        } else {
            this.drawVerticalTitle(e.gc);
        }
        e.gc.setFont(oldFont);
        e.gc.setForeground(oldForeground);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    private void drawHorizontalTitle(GC gc) {
        boolean useStyleRanges = this.styleRanges != null;
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        if (useStyleRanges) {
            this.textLayout.draw(gc, x, y);
        } else {
            gc.drawText(this.text, x, y, true);
        }
    }

    private void drawVerticalTitle(GC gc) {
        boolean useStyleRanges = this.styleRanges != null;
        int textWidth = this.getBounds().height;
        int textHeight = this.getBounds().width;
        if (this.getFont().getFontData()[0].getStyle() == 2) {
            int margin = textHeight / 10;
            textWidth += margin;
        }
        Image image = new Image((Device)Display.getCurrent(), textWidth, textHeight);
        GC tmpGc = new GC((Drawable)image);
        if (useStyleRanges) {
            this.textLayout.draw(tmpGc, 0, 0);
        } else {
            tmpGc.setBackground(this.chart.getBackground());
            tmpGc.setForeground(this.getForeground());
            tmpGc.setFont(this.getFont());
            tmpGc.fillRectangle(image.getBounds());
            tmpGc.drawText(this.text, 0, 0);
        }
        Transform oldTransform = new Transform(gc.getDevice());
        gc.getTransform(oldTransform);
        Transform transform = new Transform(gc.getDevice());
        transform.translate(0.0f, (float)textWidth);
        transform.rotate(270.0f);
        gc.setTransform(transform);
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        gc.drawImage(image, -y, x);
        gc.setTransform(oldTransform);
        oldTransform.dispose();
        tmpGc.dispose();
        transform.dispose();
        image.dispose();
    }
}

