/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs.module;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class GraphProviderStub
extends AbstractTmfGraphProvider {
    public GraphProviderStub(@NonNull ITmfTrace trace) {
        super(trace, "Graph Provider Stub");
        this.registerHandler((ITraceEventHandler)new StubEventHandler());
    }

    public @NonNull List<@NonNull ITraceEventHandler> getHandlers() {
        return super.getHandlers();
    }

    private class StubEventHandler
    extends AbstractTraceEventHandler {
        public StubEventHandler() {
            super(5);
        }

        public void handleEvent(ITmfEvent event) {
            String evname = event.getType().getName();
            ITmfGraph graph = GraphProviderStub.this.getGraph();
            if (graph == null) {
                throw new IllegalStateException();
            }
            switch (evname) {
                case "take": {
                    TestGraphWorker player = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"player"}).getValue())));
                    ITmfVertex v = graph.createVertex((IGraphWorker)player, event.getTimestamp().getValue());
                    graph.add(v);
                    break;
                }
                case "pass": {
                    TestGraphWorker playerFrom = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"from"}).getValue())));
                    TestGraphWorker playerTo = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"to"}).getValue())));
                    ITmfVertex vFrom = graph.createVertex((IGraphWorker)playerFrom, event.getTimestamp().getValue());
                    ITmfVertex vTo = graph.createVertex((IGraphWorker)playerTo, event.getTimestamp().getValue());
                    graph.append(vFrom);
                    graph.add(vTo);
                    graph.edge(vFrom, vTo, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
                    break;
                }
                case "kick": {
                    TestGraphWorker player = new TestGraphWorker((Integer)NonNullUtils.checkNotNull((Object)((Integer)event.getContent().getField(new String[]{"player"}).getValue())));
                    ITmfVertex v = graph.createVertex((IGraphWorker)player, event.getTimestamp().getValue());
                    graph.append(v);
                    break;
                }
            }
        }
    }
}

