/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.ArtifactRepositoryValidator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeRepositoryApplication
extends AbstractApplication {
    private List<RepositoryDescriptor> childrenToAdd = new ArrayList<RepositoryDescriptor>();
    private List<RepositoryDescriptor> childrenToRemove = new ArrayList<RepositoryDescriptor>();
    private boolean removeAllChildren = false;
    private boolean failOnExists = false;
    private String comparatorID = null;

    @Override
    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        block11: {
            IStatus iStatus;
            try {
                this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
                ICompositeRepository metadataRepo = (ICompositeRepository)this.destinationMetadataRepository;
                CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.destinationArtifactRepository;
                if (this.removeAllChildren) {
                    if (artifactRepo != null) {
                        artifactRepo.removeAllChildren();
                    }
                    if (metadataRepo != null) {
                        metadataRepo.removeAllChildren();
                    }
                } else {
                    for (RepositoryDescriptor child : this.childrenToRemove) {
                        if (child.isArtifact() && artifactRepo != null) {
                            artifactRepo.removeChild(child.getOriginalRepoLocation());
                        }
                        if (!child.isMetadata() || metadataRepo == null) continue;
                        metadataRepo.removeChild(child.getOriginalRepoLocation());
                    }
                }
                for (RepositoryDescriptor child : this.childrenToAdd) {
                    if (child.isArtifact() && artifactRepo != null) {
                        artifactRepo.addChild(child.getOriginalRepoLocation());
                    }
                    if (!child.isMetadata() || metadataRepo == null) continue;
                    metadataRepo.addChild(child.getOriginalRepoLocation());
                }
                if (this.comparatorID == null) break block11;
                ArtifactRepositoryValidator validator = new ArtifactRepositoryValidator(this.comparatorID);
                iStatus = validator.validateComposite(artifactRepo);
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.finalizeRepositories();
                throw throwable;
            }
            this.finalizeRepositories();
            return iStatus;
        }
        IStatus iStatus = Status.OK_STATUS;
        Object var6_9 = null;
        this.finalizeRepositories();
        return iStatus;
    }

    public void addChild(RepositoryDescriptor child) {
        this.childrenToAdd.add(child);
    }

    public void removeChild(RepositoryDescriptor child) {
        this.childrenToRemove.add(child);
    }

    public void setRemoveAll(boolean all) {
        this.removeAllChildren = all;
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }

    @Override
    protected IArtifactRepository initializeDestination(RepositoryDescriptor toInit, IArtifactRepositoryManager mgr) throws ProvisionException {
        mgr.removeRepository(toInit.getRepoLocation());
        try {
            IArtifactRepository repository = mgr.loadRepository(toInit.getRepoLocation(), null);
            if (this.validRepositoryLocation((IRepository<?>)repository) && this.initDestinationRepository((IRepository<?>)repository, toInit)) {
                return repository;
            }
            throw new ProvisionException((IStatus)new Status(1, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)toInit.getRepoLocation())));
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
                }
                throw e;
            }
            IArtifactRepository source = null;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), 0, null);
                }
            }
            catch (ProvisionException provisionException) {}
            try {
                IArtifactRepository repo = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : Messages.CompositeRepository_default_artifactRepo_name), "org.eclipse.equinox.p2.artifact.repository.compositeRepository", source != null ? source.getProperties() : null);
                this.initRepository((IRepository<?>)repo, toInit);
                if (toInit.getAtomic() != null) {
                    repo.setProperty("p2.atomic.composite.loading", Boolean.toString(Boolean.valueOf(toInit.getAtomic())));
                }
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(toInit.getRepoLocation());
                throw e2;
            }
        }
    }

    @Override
    protected IMetadataRepository initializeDestination(RepositoryDescriptor toInit, IMetadataRepositoryManager mgr) throws ProvisionException {
        mgr.removeRepository(toInit.getRepoLocation());
        try {
            IMetadataRepository repository = mgr.loadRepository(toInit.getRepoLocation(), null);
            if (!this.validRepositoryLocation((IRepository<?>)repository) && this.initDestinationRepository((IRepository<?>)repository, toInit)) {
                throw new ProvisionException((IStatus)new Status(1, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)toInit.getRepoLocation())));
            }
            return repository;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
                }
                throw e;
            }
            IMetadataRepository source = null;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), 0, null);
                }
            }
            catch (ProvisionException provisionException) {}
            try {
                IMetadataRepository repo = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : Messages.CompositeRepository_default_metadataRepo_name), "org.eclipse.equinox.p2.metadata.repository.compositeRepository", source != null ? source.getProperties() : null);
                this.initRepository((IRepository<?>)repo, toInit);
                if (toInit.getAtomic() != null) {
                    repo.setProperty("p2.atomic.composite.loading", Boolean.toString(Boolean.valueOf(toInit.getAtomic())));
                }
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(toInit.getRepoLocation());
                throw e2;
            }
        }
    }

    private boolean validRepositoryLocation(IRepository<?> repository) throws ProvisionException {
        if (repository instanceof ICompositeRepository) {
            if (this.failOnExists) {
                throw new ProvisionException(NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)repository.getLocation()));
            }
            RepositoryHelper.validDestinationRepository(repository);
            return true;
        }
        return true;
    }

    private void initRepository(IRepository<?> repository, RepositoryDescriptor desc) {
        RepositoryHelper.validDestinationRepository(repository);
        if (desc.isCompressed() && !repository.getProperties().containsKey("p2.compressed")) {
            repository.setProperty("p2.compressed", String.valueOf(true));
        }
    }

    public void setComparator(String value) {
        this.comparatorID = value;
    }
}

