/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.numbers.impl;

import org.eclipse.uomo.util.internal.Messages;
import org.eclipse.uomo.util.numbers.ISpeller;
import org.eclipse.uomo.util.numbers.SpellException;

public class RomanNumberSpeller
implements ISpeller {
    private static final long MAX_ROMAN = 3999L;
    private static RomanNumberSpeller INSTANCE;

    private RomanNumberSpeller() {
    }

    public static final RomanNumberSpeller of() {
        if (INSTANCE == null) {
            INSTANCE = new RomanNumberSpeller();
        }
        return INSTANCE;
    }

    @Override
    public String spell(long number) throws SpellException {
        if (number > 3999L) {
            throw new SpellException(String.valueOf(Messages.RomanNumberSpeller_0) + 3999L);
        }
        return this.toRoman(number);
    }

    public final String toRoman(long n) {
        return this.internalToRoman(n);
    }

    public final String toRoman(int n) {
        return this.toRoman((long)n);
    }

    public final String toRoman(String s) {
        return this.toRoman(Integer.parseInt(s));
    }

    private final String internalToRoman(long number) {
        StringBuilder roman = new StringBuilder("");
        long N = number;
        while (N >= 1000L) {
            roman.append(Messages.RomanNumberSpeller_2);
            N -= 1000L;
        }
        while (N >= 900L) {
            roman.append(Messages.RomanNumberSpeller_3);
            N -= 900L;
        }
        while (N >= 500L) {
            roman.append(Messages.RomanNumberSpeller_4);
            N -= 500L;
        }
        while (N >= 400L) {
            roman.append(Messages.RomanNumberSpeller_5);
            N -= 400L;
        }
        while (N >= 100L) {
            roman.append(Messages.RomanNumberSpeller_6);
            N -= 100L;
        }
        while (N >= 90L) {
            roman.append(Messages.RomanNumberSpeller_7);
            N -= 90L;
        }
        while (N >= 50L) {
            roman.append(Messages.RomanNumberSpeller_8);
            N -= 50L;
        }
        while (N >= 40L) {
            roman.append(Messages.RomanNumberSpeller_9);
            N -= 40L;
        }
        while (N >= 10L) {
            roman.append(Messages.RomanNumberSpeller_10);
            N -= 10L;
        }
        if (N == 9L) {
            roman.append(Messages.RomanNumberSpeller_11);
            N -= 9L;
        }
        while (N >= 5L) {
            roman.append(Messages.RomanNumberSpeller_12);
            N -= 5L;
        }
        if (N == 4L) {
            roman.append(Messages.RomanNumberSpeller_13);
            N -= 4L;
        }
        while (N >= 1L) {
            roman.append(Messages.RomanNumberSpeller_14);
            --N;
        }
        return roman.toString();
    }

    @Override
    public Long parse(String text) throws SpellException {
        return null;
    }
}

