/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.virgo.util.common.Assert;

public class FileDigest {
    public static final String SHA_DIGEST_ALGORITHM = "sha";
    public static final String MD5_DIGEST_ALGORITHM = "MD5";
    private static final int BUFFER_SIZE = 8192;

    public static String getFileShaDigest(File file) throws IOException {
        try {
            return FileDigest.getFileDigest(file, SHA_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.isTrue((boolean)false, (String)"Use of %s algorithm threw %s", (Object[])new Object[]{SHA_DIGEST_ALGORITHM, e});
            return null;
        }
    }

    public static String getFileDigest(File file, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        byte[] hash = FileDigest.computeHash(file, digest);
        return FileDigest.hashToString(hash);
    }

    private static String hashToString(byte[] rawHash) {
        BigInteger bi = new BigInteger(1, rawHash);
        String hash = bi.toString(16);
        if (hash.length() % 2 != 0) {
            hash = "0" + hash;
        }
        return hash;
    }

    private static byte[] computeHash(File file, MessageDigest digest) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
        }
        return digest.digest();
    }
}

