/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.shim.scope.Scope;
import org.eclipse.virgo.kernel.shim.scope.ScopeFactory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceScopingStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScopeFactory scopeFactory;
    private ScopeServiceRepository scopeServiceRepository;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public ServiceScopingStrategy(ScopeFactory scopeFactory, ScopeServiceRepository scopeServiceRepository) {
        this.scopeFactory = scopeFactory;
        this.scopeServiceRepository = scopeServiceRepository;
    }

    boolean isPotentiallyVisible(ServiceReference serviceReference, BundleContext consumingBundleContext) {
        Scope bundleScope;
        boolean matchesScope = true;
        Scope serviceScope = this.getServiceScope(serviceReference);
        if (serviceScope != null && !serviceScope.isGlobal() && !(bundleScope = this.scopeFactory.getBundleScope(consumingBundleContext.getBundle())).equals(serviceScope)) {
            matchesScope = false;
        }
        return matchesScope;
    }

    void scopeReferences(Collection references, BundleContext consumingBundleContext, String className, String filter) {
        Collection scopedReferences;
        Bundle consumingBundle = consumingBundleContext.getBundle();
        Scope lookupScope = this.getLookupScope(consumingBundle, className, filter);
        Scope consumerScope = this.getBundleScope(consumingBundle);
        if (lookupScope.isGlobal() && !consumerScope.isGlobal() && !(scopedReferences = this.getScopedReferences(references, consumerScope)).isEmpty()) {
            this.removeAllExcept(references, scopedReferences);
            return;
        }
        this.restrictServicesToScope(references, lookupScope);
    }

    private void removeAllExcept(Collection references, Collection scopedReferences) {
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            ServiceReference ref = (ServiceReference)iterator.next();
            if (scopedReferences.contains(ref)) continue;
            iterator.remove();
        }
    }

    private Collection getScopedReferences(Collection references, Scope scope) {
        HashSet<ServiceReference> scopedReferences = new HashSet<ServiceReference>();
        this.logger.debug("References input to getScopedReferences: {}", (Object)references.size());
        for (ServiceReference ref : references) {
            Scope serviceScope = this.getServiceScope(ref);
            if (!scope.equals(serviceScope)) continue;
            this.logger.debug("Adding {} ", (Object)ref);
            scopedReferences.add(ref);
        }
        this.logger.debug("References output from getScopedReferences: {}", (Object)scopedReferences.size());
        return scopedReferences;
    }

    private void restrictServicesToScope(Collection references, Scope scope) {
        this.logger.debug("Before filtering: {}", (Object)references.size());
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            ServiceReference ref = (ServiceReference)iterator.next();
            Scope serviceScope = this.getServiceScope(ref);
            if (scope.equals(serviceScope)) continue;
            this.logger.debug("Removing {} ", (Object)ref);
            iterator.remove();
        }
        this.logger.debug("After filtering: {}", (Object)references.size());
    }

    private Scope getLookupScope(Bundle consumer, String name, String filter) {
        Scope consumerScope = this.getBundleScope(consumer);
        Scope lookupScope = !consumerScope.isGlobal() && !this.scopeHasMatchingService(consumerScope, name, filter) ? this.scopeFactory.getGlobalScope() : consumerScope;
        this.logger.debug("{} > {} [{}] ({})", new Object[]{lookupScope, name, filter, consumer});
        return lookupScope;
    }

    private Scope getBundleScope(Bundle consumer) {
        return this.scopeFactory.getBundleScope(consumer);
    }

    private boolean scopeHasMatchingService(Scope scope, String name, String filter) {
        try {
            return this.scopeServiceRepository.scopeHasMatchingService(scope.getScopeName(), name, filter);
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn("Filter '{}' is not valid", (Object)e, (Object)filter);
            return false;
        }
    }

    private Scope getServiceScope(ServiceReference ref) {
        try {
            return this.scopeFactory.getServiceScope(ref);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.ServiceScopingStrategy");
    }
}

