/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.core.internal;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.config.internal.KernelConfiguration;
import org.eclipse.virgo.kernel.core.BlockingSignal;
import org.eclipse.virgo.kernel.core.BundleUtils;
import org.eclipse.virgo.kernel.core.FailureSignalledException;
import org.eclipse.virgo.kernel.core.FatalKernelException;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.core.internal.BundleStartTracker;
import org.eclipse.virgo.kernel.core.internal.KernelStatus;
import org.eclipse.virgo.kernel.core.internal.ServiceReferenceTracker;
import org.eclipse.virgo.kernel.diagnostics.KernelLogEvents;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StartupTracker {
    private static final String THREAD_NAME_STARTUP_TRACKER = "startup-tracker";
    static final String APPLICATION_CONTEXT_FILTER = "(objectClass=org.springframework.context.ApplicationContext)";
    private static final String KERNEL_EVENT_TOPIC = "org/eclipse/virgo/kernel/";
    private static final String KERNEL_EVENT_STARTING = "org/eclipse/virgo/kernel/STARTING";
    private static final String KERNEL_EVENT_STARTED = "org/eclipse/virgo/kernel/STARTED";
    private static final String KERNEL_EVENT_START_TIMED_OUT = "org/eclipse/virgo/kernel/START_TIMED_OUT";
    private static final String KERNEL_EVENT_START_FAILED = "org/eclipse/virgo/kernel/START_FAILED";
    private static final String KERNEL_BSN_PREFIX = "org.eclipse.virgo.kernel";
    private static final Logger LOGGER;
    private final KernelStatus status;
    private final KernelConfiguration configuration;
    private final Thread startupTrackingThread;
    private volatile ObjectInstance statusInstance;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("StartupTracker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.StartupTracker"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "start", "org.eclipse.virgo.kernel.core.internal.StartupTracker", "", "", "", "void"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "stop", "org.eclipse.virgo.kernel.core.internal.StartupTracker", "", "", "", "void"), 90);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerKernelStatusMBean", "org.eclipse.virgo.kernel.core.internal.StartupTracker", "", "", "", "void"), 94);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "unregisterKernelStatusMBean", "org.eclipse.virgo.kernel.core.internal.StartupTracker", "", "", "", "void"), 104);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.core.internal.StartupTracker", "", "", "", "org.slf4j.Logger"), 69);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.StartupTracker");
        LOGGER = LoggerFactory.getLogger(StartupTracker.class);
    }

    StartupTracker(BundleContext context, KernelConfiguration configuration, int startupWaitTime, BundleStartTracker asyncBundleStartTracker, Shutdown shutdown, DumpGenerator dumpGenerator) {
        try {
            this.status = new KernelStatus();
            StartupTrackingRunnable startupTrackingRunnable = new StartupTrackingRunnable(context, startupWaitTime, asyncBundleStartTracker, this.status, shutdown, dumpGenerator, null);
            this.startupTrackingThread = new Thread((Runnable)startupTrackingRunnable, THREAD_NAME_STARTUP_TRACKER);
            this.configuration = configuration;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void start() {
        try {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            try {
                this.registerKernelStatusMBean();
                this.startupTrackingThread.start();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    void stop() {
        try {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                this.unregisterKernelStatusMBean();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void registerKernelStatusMBean() {
        try {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName name = ObjectName.getInstance(this.configuration.getDomain(), "type", "KernelStatus");
                    this.statusInstance = server.registerMBean(this.status, name);
                }
                catch (JMException e) {
                    throw new FatalKernelException("Unable to register KernelStatus MBean", e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void unregisterKernelStatusMBean() {
        try {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectInstance instance = this.statusInstance;
                    if (instance != null && server.isRegistered(instance.getObjectName())) {
                        server.unregisterMBean(this.statusInstance.getObjectName());
                    }
                }
                catch (JMException e) {
                    throw new FatalKernelException("Unable to unregister KernelStatus MBean", e);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static /* synthetic */ Logger access$0() {
        try {
            Logger logger;
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                logger = LOGGER;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return logger;
        }
        catch (Throwable throwable) {
            StartupTracker.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static final class StartupTrackingRunnable
    implements Runnable {
        private final BundleContext context;
        private final int startupWaitTime;
        private final BundleStartTracker asyncBundleStartTracker;
        private final KernelStatus kernelStatus;
        private final Shutdown shutdown;
        private final DumpGenerator dumpGenerator;
        private final ServiceReferenceTracker serviceReferenceTracker;
        private EventLogger eventLogger;
        private EventAdmin eventAdmin;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

        private StartupTrackingRunnable(BundleContext context, int startupWaitTime, BundleStartTracker asyncBundleStartTracker, KernelStatus kernelStatus, Shutdown shutdown, DumpGenerator dumpGenerator) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.eventLogger = null;
                this.eventAdmin = null;
                this.context = context;
                this.startupWaitTime = startupWaitTime;
                this.asyncBundleStartTracker = asyncBundleStartTracker;
                this.kernelStatus = kernelStatus;
                this.shutdown = shutdown;
                this.dumpGenerator = dumpGenerator;
                this.serviceReferenceTracker = new ServiceReferenceTracker(context);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block16: {
                    StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    try {
                        this.eventLogger = this.getEventLoggerService();
                        this.eventAdmin = this.getEventAdminService();
                        try {
                            block15: {
                                this.kernelStarting();
                                Bundle[] bundles = this.context.getBundles();
                                try {
                                    Bundle[] bundleArray = bundles;
                                    int n = bundles.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Bundle bundle = bundleArray[n2];
                                        if (!BundleUtils.isFragmentBundle(bundle) && this.isKernelBundle(bundle)) {
                                            BlockingSignal signal = new BlockingSignal();
                                            this.asyncBundleStartTracker.trackStart(bundle, signal);
                                            StartupTracker.access$0().debug("Awaiting signal {} for up to {} seconds", (Object)signal, (Object)this.startupWaitTime);
                                            if (!signal.awaitCompletion(this.startupWaitTime, TimeUnit.SECONDS)) {
                                                StartupTracker.access$0().error("Bundle {} did not start within {} seconds.", (Object)bundle, (Object)this.startupWaitTime);
                                                this.kernelStartTimedOut();
                                            }
                                        }
                                        ++n2;
                                    }
                                    break block15;
                                }
                                catch (FailureSignalledException fse) {
                                    this.kernelStartFailed(fse.getCause());
                                }
                                catch (Exception e) {
                                    this.kernelStartFailed(e);
                                }
                                break block16;
                            }
                            this.kernelStarted();
                        }
                        finally {
                            this.serviceReferenceTracker.ungetAll();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        private EventLogger getEventLoggerService() {
            try {
                EventLogger eventLogger = null;
                ServiceReference eventLoggerServiceReference = this.context.getServiceReference(EventLogger.class.getName());
                if (eventLoggerServiceReference != null) {
                    eventLogger = (EventLogger)this.context.getService(this.serviceReferenceTracker.track(eventLoggerServiceReference));
                }
                return eventLogger;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private EventAdmin getEventAdminService() {
            try {
                EventAdmin eventAdmin = null;
                ServiceReference eventAdminServiceReference = this.context.getServiceReference(EventAdmin.class.getName());
                if (eventAdminServiceReference != null) {
                    eventAdmin = (EventAdmin)this.context.getService(this.serviceReferenceTracker.track(eventAdminServiceReference));
                }
                return eventAdmin;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        private boolean isKernelBundle(Bundle bundle) {
            try {
                boolean bl;
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                try {
                    String symbolicName = bundle.getSymbolicName();
                    bl = symbolicName != null && symbolicName.startsWith(StartupTracker.KERNEL_BSN_PREFIX);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return bl;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        private void kernelStarting() {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                try {
                    this.postEvent(StartupTracker.KERNEL_EVENT_STARTING);
                    this.logEvent(KernelLogEvents.KERNEL_STARTING, new Object[0]);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        private void kernelStarted() {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                try {
                    this.kernelStatus.setStarted();
                    this.postEvent(StartupTracker.KERNEL_EVENT_STARTED);
                    this.logEvent(KernelLogEvents.KERNEL_STARTED, new Object[0]);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }

        private void kernelStartTimedOut() {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                try {
                    this.postEvent(StartupTracker.KERNEL_EVENT_START_TIMED_OUT);
                    this.logEvent(KernelLogEvents.KERNEL_START_TIMED_OUT, this.startupWaitTime);
                    this.generateDumpAndShutdown("startupTimedOut", null);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }

        private void kernelStartFailed(Throwable failure) {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                try {
                    this.postEvent(StartupTracker.KERNEL_EVENT_START_FAILED);
                    this.logEvent(KernelLogEvents.KERNEL_START_FAILED, failure, new Object[0]);
                    this.generateDumpAndShutdown("startupFailed", failure);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }

        private void generateDumpAndShutdown(String cause, Throwable failure) {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                try {
                    if (failure != null) {
                        this.dumpGenerator.generateDump(cause, new Throwable[]{failure});
                    } else {
                        this.dumpGenerator.generateDump(cause, new Throwable[0]);
                    }
                    this.shutdown.immediateShutdown();
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }

        private void logEvent(KernelLogEvents event, Throwable throwable, Object ... args) {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                try {
                    if (this.eventLogger != null) {
                        this.eventLogger.log((LogEvent)event, throwable, args);
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable2) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable2, ajc$tjp_7);
                throw throwable2;
            }
        }

        private void logEvent(KernelLogEvents event, Object ... args) {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                try {
                    this.logEvent(event, null, args);
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }

        private void postEvent(String topic) {
            try {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
                try {
                    if (this.eventAdmin != null) {
                        this.eventAdmin.postEvent(new Event(topic, null));
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
                return;
            }
            catch (Throwable throwable) {
                StartupTrackingRunnable.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ StartupTrackingRunnable(BundleContext bundleContext, int n, BundleStartTracker bundleStartTracker, KernelStatus kernelStatus, Shutdown shutdown, DumpGenerator dumpGenerator, StartupTrackingRunnable startupTrackingRunnable) {
            DumpGenerator dumpGenerator2 = dumpGenerator;
            Shutdown shutdown2 = shutdown;
            KernelStatus kernelStatus2 = kernelStatus;
            BundleStartTracker bundleStartTracker2 = bundleStartTracker;
            int n2 = n;
            BundleContext bundleContext2 = bundleContext;
            StartupTrackingRunnable ajc$aspectInstance = this;
            try {
                void dumpGenerator3;
                void shutdown3;
                void kernelStatus3;
                void asyncBundleStartTracker;
                void startupWaitTime;
                void context;
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.eventLogger = null;
                ajc$aspectInstance.eventAdmin = null;
                ajc$aspectInstance.context = context;
                ajc$aspectInstance.startupWaitTime = startupWaitTime;
                ajc$aspectInstance.asyncBundleStartTracker = asyncBundleStartTracker;
                ajc$aspectInstance.kernelStatus = kernelStatus3;
                ajc$aspectInstance.shutdown = shutdown3;
                ajc$aspectInstance.dumpGenerator = dumpGenerator3;
                ajc$aspectInstance.serviceReferenceTracker = new ServiceReferenceTracker((BundleContext)context);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("StartupTracker.java", Class.forName("org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "", "", "", "void"), 143);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isKernelBundle", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 200);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "kernelStarting", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "", "", "", "void"), 205);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "kernelStarted", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "", "", "", "void"), 210);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "kernelStartTimedOut", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "", "", "", "void"), 216);
            ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "kernelStartFailed", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "java.lang.Throwable:", "failure:", "", "void"), 222);
            ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateDumpAndShutdown", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "java.lang.String:java.lang.Throwable:", "cause:failure:", "", "void"), 228);
            ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "logEvent", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "org.eclipse.virgo.kernel.diagnostics.KernelLogEvents:java.lang.Throwable:[Ljava.lang.Object;:", "event:throwable:args:", "", "void"), 237);
            ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "logEvent", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "org.eclipse.virgo.kernel.diagnostics.KernelLogEvents:[Ljava.lang.Object;:", "event:args:", "", "void"), 243);
            ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "postEvent", "org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable", "java.lang.String:", "topic:", "", "void"), 247);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.StartupTracker$StartupTrackingRunnable");
        }
    }
}

