/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.configuration.RemoteRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.remote.DescriptorStore;
import org.eclipse.virgo.repository.internal.remote.DescriptorStoreFactory;
import org.eclipse.virgo.repository.internal.remote.MutableArtifactDescriptorDepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArtifactDescriptorStoreWatcher {
    private final StoreUpdaterThread storeUpdaterThread;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    ArtifactDescriptorStoreWatcher(MutableArtifactDescriptorDepository mutableDepository, RemoteRepositoryConfiguration configuration) {
        this.storeUpdaterThread = new StoreUpdaterThread(mutableDepository, configuration);
    }

    void start() {
        this.storeUpdaterThread.start();
    }

    void stop() {
        this.storeUpdaterThread.stopUpdates();
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.remote.ArtifactDescriptorStoreWatcher");
    }

    static final class StoreUpdaterThread
    extends Thread {
        private static final String RESPONSE_HEADER_ETAG = "Etag";
        private static final String REPONSE_HEADER_CONTENT_ENCODING = "Content-Encoding";
        private static final String CONTENT_ENCODING_GZIP = "gzip";
        private static final String REQUEST_HEADER_IF_NONE_MATCH = "If-None-Match";
        private static final Logger LOGGER;
        private final HttpClient httpClient = new HttpClient();
        private final long msUpdateInterval;
        private final String repositoryUri;
        private final MutableArtifactDescriptorDepository mutableDepository;
        private final DescriptorStoreFactory descriptorStoreFactory;
        private final String repositoryName;
        private volatile boolean update = true;
        private int countContiguousHttpClientFailures = 0;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.remote.ArtifactDescriptorStoreWatcher$StoreUpdaterThread");
            LOGGER = LoggerFactory.getLogger(StoreUpdaterThread.class);
        }

        private StoreUpdaterThread(MutableArtifactDescriptorDepository mutableDepository, RemoteRepositoryConfiguration configuration) {
            super(configuration.getName());
            this.msUpdateInterval = configuration.getIndexUpdateInterval() * 1000;
            this.repositoryUri = configuration.getRepositoryUri().toString();
            this.mutableDepository = mutableDepository;
            this.repositoryName = configuration.getName();
            this.descriptorStoreFactory = new DescriptorStoreFactory(this.repositoryName, configuration.getIndexLocation().getParentFile());
            this.setDaemon(true);
        }

        public void run() {
            DescriptorStore descriptorStore = this.descriptorStoreFactory.recoverDescriptorStore();
            while (this.update) {
                GetMethod getIndex = new GetMethod(this.repositoryUri);
                if (descriptorStore != null) {
                    getIndex.addRequestHeader(REQUEST_HEADER_IF_NONE_MATCH, descriptorStore.getEtag());
                }
                try {
                    int responseCode = this.httpClient.executeMethod((HttpMethod)getIndex);
                    if (this.countContiguousHttpClientFailures > 0) {
                        LOGGER.info(String.format("Remote repository '%s' re-accessed after failure.", this.repositoryName));
                        this.countContiguousHttpClientFailures = 0;
                    }
                    if (responseCode == 200 || responseCode == 304) {
                        if (responseCode == 200) {
                            descriptorStore = this.readNewDescriptorStore(getIndex);
                        }
                        this.mutableDepository.setDescriptorStore(descriptorStore);
                    } else {
                        this.handleUnexpectedResponse(responseCode);
                    }
                }
                catch (IOException ioe) {
                    if (this.countContiguousHttpClientFailures == 0) {
                        LOGGER.warn(String.format("Remote repository '%s' inaccessible.", this.repositoryName), (Throwable)ioe);
                    } else if (5 > this.countContiguousHttpClientFailures) {
                        this.countContiguousHttpClientFailures = 0;
                        LOGGER.warn(String.format("Remote repository '%s' inaccessible.", this.repositoryName));
                    }
                    ++this.countContiguousHttpClientFailures;
                }
                try {
                    Thread.sleep(this.msUpdateInterval);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.info("Interrupted. Stopping updates");
                    this.update = false;
                }
            }
        }

        private void stopUpdates() {
            this.update = false;
            this.interrupt();
        }

        private void handleUnexpectedResponse(int responseCode) {
            LOGGER.error(String.format("Unexpected HTTP response code: %s from remote repository '%s'.", String.valueOf(responseCode), this.repositoryName));
        }

        private String getETag(GetMethod getIndex) {
            Header responseHeader = getIndex.getResponseHeader(RESPONSE_HEADER_ETAG);
            return responseHeader == null ? null : responseHeader.getValue();
        }

        private DescriptorStore readNewDescriptorStore(GetMethod getDescriptorStore) {
            try {
                String etag = this.getETag(getDescriptorStore);
                InputStream storeStream = getDescriptorStore.getResponseBodyAsStream();
                Header contentEncodingResponseHeader = getDescriptorStore.getResponseHeader(REPONSE_HEADER_CONTENT_ENCODING);
                if (contentEncodingResponseHeader != null && CONTENT_ENCODING_GZIP.equals(contentEncodingResponseHeader.getValue())) {
                    storeStream = new GZIPInputStream(storeStream);
                }
                return this.descriptorStoreFactory.createDescriptorStore(storeStream, etag);
            }
            catch (IOException ioe) {
                LOGGER.error(String.format("Copying index failed for remote repository '%s'.", this.repositoryName), (Throwable)ioe);
                return null;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }
    }
}

