/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.serviceability;

import java.util.Collection;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assert {
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public static void isTrue(boolean expression, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            if (!expression) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public static void isFalse(boolean expression, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            if (expression) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public static void isNull(Object object, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            if (object != null) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public static void notNull(Object object, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            if (object == null) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public static void hasLength(String text, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            if (text == null || text.length() == 0) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public static void notEmpty(Object[] array, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            if (array == null || array.length == 0) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    public static <T> void notEmpty(Collection<T> collection, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            if (collection == null || collection.isEmpty()) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    public static <K, V> void notEmpty(Map<K, V> map, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            if (map == null || map.isEmpty()) {
                throw new FatalAssertionException(String.format(message, inserts));
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    public static <T> void isInstanceOf(Class<T> type, Object obj, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
            Assert.notNull(type, "The type to check against must not be null", new Object[0]);
            if (!type.isInstance(obj)) {
                throw new FatalAssertionException(String.valueOf(String.format(message, inserts)) + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    public static <T, U> void isAssignable(Class<T> superType, Class<U> subType, String message, Object ... inserts) {
        try {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
            Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
            if (subType == null || !superType.isAssignableFrom(subType)) {
                throw new FatalAssertionException(String.valueOf(String.format(message, inserts)) + subType + " is not assignable to " + superType);
            }
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            Assert.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    private Assert() {
    }

    static {
        Factory factory = new Factory("Assert.java", Class.forName("org.eclipse.virgo.kernel.serviceability.Assert"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "isTrue", "org.eclipse.virgo.kernel.serviceability.Assert", "boolean:java.lang.String:[Ljava.lang.Object;:", "expression:message:inserts:", "", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "isFalse", "org.eclipse.virgo.kernel.serviceability.Assert", "boolean:java.lang.String:[Ljava.lang.Object;:", "expression:message:inserts:", "", "void"), 83);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "isNull", "org.eclipse.virgo.kernel.serviceability.Assert", "java.lang.Object:java.lang.String:[Ljava.lang.Object;:", "object:message:inserts:", "", "void"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "notNull", "org.eclipse.virgo.kernel.serviceability.Assert", "java.lang.Object:java.lang.String:[Ljava.lang.Object;:", "object:message:inserts:", "", "void"), 119);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "hasLength", "org.eclipse.virgo.kernel.serviceability.Assert", "java.lang.String:java.lang.String:[Ljava.lang.Object;:", "text:message:inserts:", "", "void"), 137);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "notEmpty", "org.eclipse.virgo.kernel.serviceability.Assert", "[Ljava.lang.Object;:java.lang.String:[Ljava.lang.Object;:", "array:message:inserts:", "", "void"), 155);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "notEmpty", "org.eclipse.virgo.kernel.serviceability.Assert", "java.util.Collection:java.lang.String:[Ljava.lang.Object;:", "collection:message:inserts:", "", "void"), 175);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "notEmpty", "org.eclipse.virgo.kernel.serviceability.Assert", "java.util.Map:java.lang.String:[Ljava.lang.Object;:", "map:message:inserts:", "", "void"), 195);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "isInstanceOf", "org.eclipse.virgo.kernel.serviceability.Assert", "java.lang.Class:java.lang.Object:java.lang.String:[Ljava.lang.Object;:", "type:obj:message:inserts:", "", "void"), 218);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "isAssignable", "org.eclipse.virgo.kernel.serviceability.Assert", "java.lang.Class:java.lang.Class:java.lang.String:[Ljava.lang.Object;:", "superType:subType:message:inserts:", "", "void"), 243);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.serviceability.Assert");
    }

    public static final class FatalAssertionException
    extends RuntimeException {
        private static final long serialVersionUID = -4633344457818398425L;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public FatalAssertionException(String message) {
            super(message);
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.serviceability.Assert$FatalAssertionException");
        }
    }
}

