/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.combokit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboOperationHandler
extends ControlOperationHandler<Combo> {
    private static final String PROP_SELECTION_INDEX = "selectionIndex";
    private static final String PROP_LIST_VISIBLE = "listVisible";
    private static final String PROP_TEXT = "text";
    private static final String PROP_SELECTION = "selection";

    public ComboOperationHandler(Combo combo) {
        super(combo);
    }

    @Override
    public void handleSet(Combo combo, JsonObject properties) {
        super.handleSet(combo, properties);
        this.handleSetSelectionIndex(combo, properties);
        this.handleSetListVisible(combo, properties);
        this.handleSetText(combo, properties);
        this.handleSetSelection(combo, properties);
    }

    @Override
    public void handleNotify(Combo combo, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(combo, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(combo, properties);
        } else if ("Modify".equals(eventName)) {
            this.handleNotifyModify(combo, properties);
        } else {
            super.handleNotify(combo, eventName, properties);
        }
    }

    public void handleSetSelectionIndex(Combo combo, JsonObject properties) {
        JsonValue selectionIndex = properties.get(PROP_SELECTION_INDEX);
        if (selectionIndex != null) {
            combo.select(selectionIndex.asInt());
        }
    }

    public void handleSetListVisible(Combo combo, JsonObject properties) {
        JsonValue listVisible = properties.get(PROP_LIST_VISIBLE);
        if (listVisible != null) {
            combo.setListVisible(listVisible.asBoolean());
        }
    }

    public void handleSetText(final Combo combo, JsonObject properties) {
        JsonValue value = properties.get(PROP_TEXT);
        if (value != null) {
            final String text = value.asString();
            if (EventLCAUtil.isListening(combo, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        ComboOperationHandler.setText(combo, text);
                        WidgetUtil.getAdapter(combo).preserve(ComboOperationHandler.PROP_TEXT, text);
                    }
                });
            } else {
                ComboOperationHandler.setText(combo, text);
            }
        }
    }

    public void handleSetSelection(final Combo combo, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            final Point selection = JsonMapping.readPoint(value);
            if (EventLCAUtil.isListening(combo, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        combo.setSelection(selection);
                        WidgetUtil.getAdapter(combo).preserve(ComboOperationHandler.PROP_SELECTION, combo.getSelection());
                    }
                });
            } else {
                combo.setSelection(selection);
            }
        }
    }

    public void handleNotifySelection(Combo combo, JsonObject properties) {
        Event event = ComboOperationHandler.createSelectionEvent(13, properties);
        combo.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(Combo combo, JsonObject properties) {
        Event event = ComboOperationHandler.createSelectionEvent(14, properties);
        combo.notifyListeners(14, event);
    }

    public void handleNotifyModify(Combo combo, JsonObject properties) {
    }

    private static void setText(Combo combo, String value) {
        if (!combo.getText().equals(value)) {
            combo.getAdapter(ITextAdapter.class).setText(value);
        }
    }
}

