/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemOperationHandler;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class ToolItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ToolItem";
    private static final String[] ALLOWED_STYLES = new String[]{"PUSH", "CHECK", "RADIO", "SEPARATOR", "DROP_DOWN"};
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HOT_IMAGE = "hotImage";
    private static final String PROP_CONTROL = "control";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    public void preserveValues(Widget widget) {
        ToolItem item = (ToolItem)widget;
        WidgetLCAUtil.preserveBounds(item, item.getBounds());
        WidgetLCAUtil.preserveEnabled(item, item.getEnabled());
        WidgetLCAUtil.preserveToolTipText(item, item.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveData(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_VISIBLE, ToolItemLCA.isVisible(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, item.getText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, ToolItemLCA.getImage(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_HOT_IMAGE, item.getHotImage());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_CONTROL, item.getControl());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SELECTION, item.getSelection());
        if (!ToolItemLCA.isSeparator(item)) {
            WidgetLCAUtil.preserveListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13));
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        ToolItem item = (ToolItem)widget;
        ToolBar toolBar = item.getParent();
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new ToolItemOperationHandler(item));
        remoteObject.set("parent", WidgetUtil.getId(toolBar));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(item, ALLOWED_STYLES)));
        remoteObject.set("index", toolBar.indexOf(item));
    }

    public void renderChanges(Widget widget) throws IOException {
        ToolItem item = (ToolItem)widget;
        WidgetLCAUtil.renderBounds(item, item.getBounds());
        WidgetLCAUtil.renderEnabled(item, item.getEnabled());
        WidgetLCAUtil.renderToolTip(item, item.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        ToolItemLCA.renderText(item);
        ToolItemLCA.renderMnemonicIndex(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_VISIBLE, ToolItemLCA.isVisible(item), true);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, ToolItemLCA.getImage(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_HOT_IMAGE, item.getHotImage(), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CONTROL, item.getControl(), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SELECTION, item.getSelection(), false);
        if (!ToolItemLCA.isSeparator(item)) {
            WidgetLCAUtil.renderListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13), false);
        }
    }

    private static void renderText(ToolItem item) {
        String newValue = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            RemoteObjectFactory.getRemoteObject(item).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(ToolItem item) {
        int mnemonicIndex;
        String text = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(item).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    private static boolean isVisible(ToolItem item) {
        return item.getAdapter(IToolItemAdapter.class).getVisible();
    }

    static Image getImage(ToolItem item) {
        Image result;
        if (item.getEnabled() && item.getParent().getEnabled()) {
            result = item.getImage();
        } else {
            result = item.getDisabledImage();
            if (result == null) {
                result = item.getImage();
            }
        }
        return result;
    }

    private static boolean isSeparator(ToolItem item) {
        return (item.getStyle() & 2) != 0;
    }
}

