/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.ModelTools;

public abstract class AbstractSelectionProvider
implements ISelectionProvider {
    private final ExceptionHandler exceptionHandler;
    private final ListenerList<ISelectionChangedListener> listenerList = ModelTools.listenerList();

    protected AbstractSelectionProvider(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listenerList) {
            this.fireSelectionChanged(listener, event);
        }
    }

    private void fireSelectionChanged(ISelectionChangedListener listener, SelectionChangedEvent event) {
        try {
            listener.selectionChanged(event);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

