/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;

public final class SemanticToken {
    private SimpleName fNode;
    private Expression fLiteral;
    private IBinding fBinding;
    private boolean fIsBindingResolved = false;
    private JavaScriptUnit fRoot;
    private boolean fIsRootResolved = false;

    public IBinding getBinding() {
        if (!this.fIsBindingResolved) {
            this.fIsBindingResolved = true;
            if (this.fNode != null) {
                this.fBinding = this.fNode.resolveBinding();
            }
        }
        return this.fBinding;
    }

    public SimpleName getNode() {
        return this.fNode;
    }

    public Expression getLiteral() {
        return this.fLiteral;
    }

    public JavaScriptUnit getRoot() {
        if (!this.fIsRootResolved) {
            this.fIsRootResolved = true;
            this.fRoot = (JavaScriptUnit)(this.fNode != null ? this.fNode : this.fLiteral).getRoot();
        }
        return this.fRoot;
    }

    void update(SimpleName node) {
        this.clear();
        this.fNode = node;
    }

    void update(Expression literal) {
        this.clear();
        this.fLiteral = literal;
    }

    void clear() {
        this.fNode = null;
        this.fLiteral = null;
        this.fBinding = null;
        this.fIsBindingResolved = false;
        this.fRoot = null;
        this.fIsRootResolved = false;
    }
}

