/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.applicationclient.ApplicationClientDeploymentDescriptor;
import org.eclipse.jst.javaee.applicationclient.ApplicationclientFactory;
import org.eclipse.jst.javaee.applicationclient.IApplicationClientResource;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.jee.model.internal.JEE5ModelProvider;

public class AppClient5ModelProvider
extends JEE5ModelProvider {
    private static final String APPCLIENT5_CONTENT_TYPE = "org.eclipse.jst.jee.ee5appclientDD";

    public AppClient5ModelProvider(IProject proj) {
        this.proj = proj;
        this.setDefaultResourcePath((IPath)new Path("META-INF/application-client.xml"));
    }

    public Object getModelObject(IPath modelPath) {
        IApplicationClientResource appRes = (IApplicationClientResource)this.getModelResource(modelPath);
        if (appRes != null && appRes.getRootObject() != null) {
            return appRes.getApplicationClient();
        }
        return null;
    }

    protected String getContentTypeDescriber() {
        return APPCLIENT5_CONTENT_TYPE;
    }

    public void populateRoot(XMLResourceImpl res, String name) {
        ApplicationClientDeploymentDescriptor dd = ApplicationclientFactory.eINSTANCE.createApplicationClientDeploymentDescriptor();
        dd.getXMLNSPrefixMap().put("", "http://java.sun.com/xml/ns/javaee");
        dd.getXMLNSPrefixMap().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ApplicationClient client = ApplicationclientFactory.eINSTANCE.createApplicationClient();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        client.getDisplayNames().add(dn);
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.proj);
        if (version != null && version.equals("5.0")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application-client_5.xsd");
            client.setVersion("5");
        } else if (version != null && version.equals("6.0")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/application-client_6.xsd");
            client.setVersion("6");
        } else if (version != null && version.equals("7.0")) {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application-client_7.xsd");
            client.setVersion("7");
        } else {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/application-client_8.xsd");
            client.setVersion("8");
        }
        dd.setApplicationClient(client);
        res.getContents().add((Object)((EObject)dd));
    }
}

