/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jst.ws.jaxws.utils.annotations.ILocator;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueImpl
implements IValue {
    private ILocator locator = null;

    protected abstract Expression getExpression(CompilationUnit var1, AST var2);

    protected boolean addImports(AST ast, CompilationUnit unit, String annotationName) {
        String packageAnnotationName = ValueImpl.getPackageName(annotationName);
        if (packageAnnotationName == null) {
            return false;
        }
        if (packageAnnotationName.equals("java.lang")) {
            return true;
        }
        if (unit != null) {
            ImportDeclaration imp = ast.newImportDeclaration();
            imp.setName(ast.newName(annotationName));
            List imports = unit.imports();
            String imp1 = ValueImpl.getImport(imports, ValueImpl.getSimpleName(annotationName));
            if (imp1 == null) {
                if (ValueImpl.getOnDemandImport(imports, packageAnnotationName) == null) {
                    imports.add(imp);
                }
            } else if (!imp1.equals(annotationName)) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected static String getImport(List<ImportDeclaration> imports, String imp) {
        for (ImportDeclaration next : imports) {
            Name fqName = next.getName();
            SimpleName name = fqName.isQualifiedName() ? ((QualifiedName)fqName).getName() : (SimpleName)fqName;
            String simpleName = name.getIdentifier();
            if (!imp.equals(simpleName)) continue;
            return fqName.getFullyQualifiedName();
        }
        return null;
    }

    protected static String getOnDemandImport(List<ImportDeclaration> imports, String imp) {
        for (ImportDeclaration next : imports) {
            Name fqName;
            String name;
            if (!next.isOnDemand() || !imp.equals(name = (fqName = next.getName()).getFullyQualifiedName())) continue;
            return name;
        }
        return null;
    }

    protected static String getPackageName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return name.substring(0, i);
    }

    protected static String getSimpleName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    @Override
    public ILocator getLocator() {
        return this.locator;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }
}

