/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.TableUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.ChooseVmControl;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditDiffViewer;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;

public class LiveEditResultDialog
extends Dialog {
    private final Input input;
    private final ErrorPositionHighlighter positionHighlighter;

    public static SingleInput createTextInput(String text, PushChangesPlan changesPlan) {
        return LiveEditResultDialog.createTextInput(text, changesPlan, UpdatableScript.Failure.UNSPECIFIED);
    }

    public static SingleInput createTextInput(final String text, final PushChangesPlan changesPlan, final UpdatableScript.Failure failure) {
        return new SingleInput(){

            @Override
            public <RES> RES accept(InputVisitor<RES> visitor) {
                return this.acceptSingle(visitor);
            }

            @Override
            public <RES> RES acceptSingle(SingleInputVisitor<RES> visitor) {
                return visitor.visitErrorMessage(text, failure);
            }

            @Override
            public ScriptTargetMapping getFilePair() {
                return changesPlan.getScriptTargetMapping();
            }
        };
    }

    public LiveEditResultDialog(Shell shell, Input input, ErrorPositionHighlighter positionHighlighter) {
        super(shell);
        this.input = input;
        this.positionHighlighter = positionHighlighter;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LiveEditResultDialog_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite composite = (Composite)super.createDialogArea(parent);
        this.input.accept(new InputVisitor<Void>(){

            @Override
            public Void visitErrorMessage(final String text, UpdatableScript.Failure failure) {
                return (Void)failure.accept((UpdatableScript.Failure.Visitor)new UpdatableScript.Failure.Visitor<Void>(){

                    public Void visitUnspecified() {
                        LiveEditResultDialog.this.createErrorMessageControls(composite, text);
                        return null;
                    }

                    public Void visitCompileError(UpdatableScript.CompileErrorFailure compileError) {
                        LiveEditResultDialog.this.createErrorWithPositionControls(composite, Messages.LiveEditResultDialog_COMPILE_ERROR, compileError.getCompilerMessage(), compileError.getStartPosition(), compileError.getEndPosition());
                        return null;
                    }
                });
            }

            @Override
            public Void visitSuccess(SuccessResult successResult) {
                LiveEditResultDialog.this.createSuccessResultControls(composite, successResult);
                return null;
            }

            @Override
            public Void visitMultipleResult(MultipleResult multipleResult) {
                LiveEditResultDialog.this.createMultipleResultsControl(composite, multipleResult);
                return null;
            }
        });
        return composite;
    }

    private void createErrorMessageControls(Composite parent, String text) {
        Text textControl = new Text(parent, 64);
        Display display = parent.getDisplay();
        textControl.setBackground(display.getSystemColor(22));
        textControl.setText(text);
    }

    private void createErrorWithPositionControls(Composite parent, String localMessage, String remoteMessage, final TextStreamPosition startPosition, TextStreamPosition endPosition) {
        Display display = parent.getDisplay();
        Composite messageComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        messageComposite.setLayout((Layout)gridLayout);
        Label localMessageLabel = new Label(messageComposite, 0);
        localMessageLabel.setText(localMessage);
        Text textControl = new Text(messageComposite, 8);
        textControl.setBackground(display.getSystemColor(22));
        textControl.setText(remoteMessage);
        textControl.setEditable(false);
        Composite positionComposite = new Composite(parent, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        positionComposite.setLayout((Layout)gridLayout2);
        Label startLabel = new Label(positionComposite, 0);
        startLabel.setText(NLS.bind((String)Messages.LiveEditResultDialog_LINE_COLUMN, (Object)startPosition.getLine(), (Object)startPosition.getColumn()));
        Button setPositionButton = new Button(positionComposite, 0);
        setPositionButton.setText(Messages.LiveEditResultDialog_SELECT_IN_EDITOR);
        if (this.positionHighlighter == null) {
            setPositionButton.setEnabled(false);
        } else {
            final int length = endPosition == null ? 0 : endPosition.getOffset() - startPosition.getOffset();
            setPositionButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LiveEditResultDialog.this.positionHighlighter.highlight(startPosition.getOffset(), length);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(null);
                }
            });
        }
    }

    private void createSuccessResultControls(Composite parent, SuccessResult successResult) {
        OldScriptData withOldScript;
        Label label1 = new Label(parent, 0);
        label1.setText(Messages.LiveEditResultDialog_SUCCESS);
        if (successResult.hasDroppedFrames()) {
            Label label2 = new Label(parent, 0);
            label2.setText(Messages.LiveEditResultDialog_FRAMES_DROPPED);
        }
        if ((withOldScript = successResult.getOldScriptData()) != null) {
            Label new_script_label = new Label(parent, 0);
            new_script_label.setText(Messages.LiveEditResultDialog_SCRIPT_CREATED);
            LiveEditDiffViewer.Configuration configuration = new LiveEditDiffViewer.Configuration(){

                @Override
                public String getNewLabel() {
                    return Messages.LiveEditResultDialog_CURRENT_SCRIPT;
                }

                @Override
                public String getOldLabel() {
                    return NLS.bind((String)Messages.LiveEditResultDialog_OLD_SCRIPT, (Object)withOldScript.getOldScriptName());
                }

                @Override
                public boolean oldOnLeft() {
                    return false;
                }
            };
            LiveEditDiffViewer viewer = LiveEditDiffViewer.create(parent, configuration);
            viewer.setInput(withOldScript.getScriptStructure());
        }
    }

    private void createMultipleResultsControl(Composite parent, MultipleResult multipleResult) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LiveEditResultDialog_SEVERAL_VMS);
        label.setLayoutData((Object)new GridData(768));
        Table table = new Table(parent, 2048);
        table.setFont(parent.getFont());
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        TableUtils.ValueAdapter<SingleInput, ConnectedTargetData> inputToTargetAdapter = new TableUtils.ValueAdapter<SingleInput, ConnectedTargetData>(){

            @Override
            public ConnectedTargetData convert(SingleInput from) {
                return from.getFilePair().getConnectedTargetData();
            }
        };
        ArrayList columnDataList = new ArrayList(ChooseVmControl.createLaunchTargetColumns(inputToTargetAdapter));
        columnDataList.add(TableUtils.ColumnData.create(new TableUtils.TrivialAdapter(), new StatusLabelProvider()));
        for (TableUtils.ColumnData columnData : columnDataList) {
            columnData.getLabelProvider().createColumn(table);
        }
        TableViewer tableViewer = new TableViewer(table);
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                MultipleResult input = (MultipleResult)inputElement;
                return input.getList().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        TableUtils.ColumnBasedLabelProvider<SingleInput> labelProvider = new TableUtils.ColumnBasedLabelProvider<SingleInput>(TableUtils.createCastAdapter(SingleInput.class), columnDataList);
        tableViewer.setLabelProvider(labelProvider);
        tableViewer.setInput((Object)multipleResult);
    }

    public static interface ErrorPositionHighlighter {
        public void highlight(int var1, int var2);
    }

    public static interface Input {
        public <RES> RES accept(InputVisitor<RES> var1);
    }

    public static interface InputVisitor<RES>
    extends SingleInputVisitor<RES> {
        public RES visitMultipleResult(MultipleResult var1);
    }

    public static interface MultipleResult {
        public List<? extends SingleInput> getList();
    }

    public static interface OldScriptData {
        public LiveEditDiffViewer.Input getScriptStructure();

        public String getOldScriptName();
    }

    public static interface SingleInput
    extends Input {
        public <RES> RES acceptSingle(SingleInputVisitor<RES> var1);

        public ScriptTargetMapping getFilePair();
    }

    public static interface SingleInputVisitor<RES> {
        public RES visitSuccess(SuccessResult var1);

        public RES visitErrorMessage(String var1, UpdatableScript.Failure var2);
    }

    private static class StatusLabelProvider
    extends TableUtils.ColumnLabelProvider<SingleInput> {
        private final SingleInputVisitor<String> textGetterVisitor = new SingleInputVisitor<String>(){

            @Override
            public String visitErrorMessage(final String text, UpdatableScript.Failure failure) {
                String message = (String)failure.accept((UpdatableScript.Failure.Visitor)new UpdatableScript.Failure.Visitor<String>(){

                    public String visitUnspecified() {
                        return text;
                    }

                    public String visitCompileError(UpdatableScript.CompileErrorFailure compileError) {
                        TextStreamPosition start = compileError.getStartPosition();
                        return NLS.bind((String)"{0} ({1}:{2})", (Object[])new Object[]{compileError.getCompilerMessage(), start.getLine(), start.getColumn()});
                    }
                });
                return NLS.bind((String)Messages.LiveEditResultDialog_FAILURE, (Object)message);
            }

            @Override
            public String visitSuccess(SuccessResult successResult) {
                return Messages.LiveEditResultDialog_OK;
            }
        };

        private StatusLabelProvider() {
        }

        @Override
        public Image getColumnImage(SingleInput element) {
            return null;
        }

        @Override
        public String getColumnText(SingleInput element) {
            return element.acceptSingle(this.textGetterVisitor);
        }

        @Override
        public TableColumn createColumn(Table table) {
            TableColumn statusCol = new TableColumn(table, 0);
            statusCol.setText(Messages.LiveEditResultDialog_STATUS);
            statusCol.setWidth(200);
            return statusCol;
        }
    }

    public static interface SuccessResult {
        public boolean hasDroppedFrames();

        public OldScriptData getOldScriptData();
    }
}

