/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelCompletionTests;
import org.eclipse.wst.jsdt.core.tests.model.CompletionTestsRequestor2;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.parser.JavadocTagConstants;

public abstract class AbstractJavadocCompletionModelTest
extends AbstractJavaModelCompletionTests
implements JavadocTagConstants {
    protected static final int JAVADOC_RELEVANCE = 8;
    protected static final int R_DIUNR = 11;
    protected static final int R_DICNR = 18;
    protected static final int R_DICQNR = 20;
    protected static final int R_DICUNR = 21;
    protected static final int R_DICENNR = 22;
    protected static final int R_DICENQNR = 24;
    protected static final int R_DICENUNR = 25;
    protected static final int R_DICNRNS = 29;
    protected static final int R_DICENNRNS = 33;
    protected static final int R_DICNRE = 38;
    protected static final int R_DICUNRE = 41;
    protected static final int R_DICENNRE = 42;
    protected static final int R_DICENUNRE = 45;
    protected static final int R_DICNREET = 48;
    protected static final int R_DICUNREET = 51;
    protected static final int R_DICUNREETE = 71;
    protected static final int R_DICNREEET = 68;
    protected static final int R_DICUNREEET = 71;
    protected static final int R_DICENNREEET = 72;
    protected static final int R_DICENUNREEET = 75;
    protected static final int JAVADOC_RELEVANCE_IT = 39;
    protected static final int R_DICNRIT = 49;
    protected static final int R_DICUNRIT = 52;
    protected static final int R_DICENNRIT = 53;
    protected static final int R_DICENUNRIT = 56;
    protected static final int R_DICNRNSIT = 60;
    protected static final int R_DICNREETIT = 79;
    protected static final int R_DICUNREETIT = 82;
    private static final int[] RELEVANCES = new int[]{8, 11, 18, 20, 21, 22, 24, 25, 29, 33, 38, 41, 42, 45, 48, 51, 68, 71, 72, 75, 39, 49, 52, 53, 56, 60, 79, 82};
    private static final String[] RELEVANCES_NAMES = new String[]{"JAVADOC_RELEVANCE", "R_DIUNR", "R_DICNR", "R_DICQNR", "R_DICUNR", "R_DICENNR", "R_DICENQNR", "R_DICENUNR", "R_DICNRNS", "R_DICENNRNS", "R_DICNRE", "R_DICUNRE", "R_DICENNRE", "R_DICENUNRE", "R_DICNREET", "R_DICUNREET", "R_DICNREEET", "R_DICUNREEET", "R_DICENNREEET", "R_DICENUNREEET", "JAVADOC_RELEVANCE_IT", "R_DICNRIT", "R_DICUNRIT", "R_DICENNRIT", "R_DICENUNRIT", "R_DICNRNSIT", "R_DICNREETIT", "R_DICUNREETIT"};
    protected static final String WRITE_DIR = System.getProperty("writeDir");
    protected static final File WRITE_DIR_FILE;
    protected static final Set PACKAGE_FILES;
    CompletionTestsRequestor2 requestor;
    protected int cursorLocation;
    protected int completionStart;
    protected String replacedText;
    protected String positions;

    static {
        PACKAGE_FILES = new HashSet();
        File writeDir = null;
        if (WRITE_DIR != null && !(writeDir = new File(WRITE_DIR)).exists() && !writeDir.mkdirs()) {
            System.err.println(String.valueOf(WRITE_DIR) + " does NOT exist and cannot be created!!!");
            writeDir = null;
        }
        WRITE_DIR_FILE = writeDir;
    }

    public AbstractJavadocCompletionModelTest(String name) {
        super(name);
        this.tabs = 2;
        this.displayName = true;
        this.endChar = "";
    }

    public static Test suite() {
        return AbstractJavadocCompletionModelTest.buildModelTestSuite(AbstractJavadocCompletionModelTest.class);
    }

    protected void assertResults(String expected) throws JavaScriptModelException {
        int length = this.workingCopies.length;
        String[] sources = new String[length * 2];
        int i = 0;
        while (i < length) {
            sources[i * 2] = this.workingCopies[i].getPath().toString();
            sources[i * 2 + 1] = this.workingCopies[i].getSource();
            ++i;
        }
        this.assertResults(sources, expected, this.requestor.getResultsWithoutSorting());
    }

    protected void assertSortedResults(String expected) throws JavaScriptModelException {
        int length = this.workingCopies.length;
        String[] sources = new String[length * 2];
        int i = 0;
        while (i < length) {
            sources[i * 2] = this.workingCopies[i].getPath().toString();
            sources[i * 2 + 1] = this.workingCopies[i].getSource();
            ++i;
        }
        this.assertResults(sources, expected, this.requestor.getReversedResults());
    }

    private void assertResults(String[] sources, String expected, String actual) {
        int count = this.requestor.proposalsPtr + 1;
        if (!expected.equals(actual)) {
            System.out.println("********************************************************************************");
            if (this.displayName) {
                System.out.print(this.getName());
                System.out.print(" got ");
                if (count == 0) {
                    System.out.println("no result!");
                } else {
                    System.out.print(count);
                    System.out.print(" result");
                    if (count == 1) {
                        System.out.println(":");
                    } else {
                        System.out.println("s:");
                    }
                }
            }
            if (!this.displayName || count > 0) {
                System.out.println(this.displayString(actual, this.tabs));
                System.out.println(this.endChar);
            }
            System.out.println("--------------------------------------------------------------------------------");
            int i = 0;
            int length = sources.length;
            while (i < length) {
                System.out.println(sources[i]);
                System.out.println(sources[i + 1]);
                i += 2;
            }
        }
        AbstractJavadocCompletionModelTest.assertEquals((String)"Completion proposals are not correct!", (String)expected, (String)actual);
    }

    protected void assertNoProblem(String path) {
        String problem = this.requestor.getProblem();
        if (problem.length() > 0) {
            System.out.println("********************************************************************************");
            if (this.displayName) {
                System.out.print(this.getName());
                System.out.println(" contains an error although it should NOT:");
            }
            System.out.println(this.displayString(problem, this.tabs));
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(String.valueOf(this.workingCopies[0].getPath().toString()) + '\n');
            try {
                System.out.println(this.workingCopies[0].getSource());
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            AbstractJavadocCompletionModelTest.assertEquals((String)(String.valueOf(path) + " should have NO problem!"), (String)"", (String)problem);
        }
    }

    protected void completeInJavadoc(String path, String source, boolean showPositions, String completeBehind) throws JavaScriptModelException {
        this.completeInJavadoc(path, source, showPositions, completeBehind, 1);
    }

    protected void completeInJavadoc(String path, String source, boolean showPositions, String completeBehind, boolean last) throws JavaScriptModelException {
        this.completeInJavadoc(path, source, showPositions, completeBehind, last ? -1 : 1);
    }

    protected void completeInJavadoc(String path, String source, boolean showPositions, String completeBehind, int occurencePosition) throws JavaScriptModelException {
        this.completeInJavadoc(new String[]{path, source}, showPositions, completeBehind, occurencePosition, null);
    }

    protected void completeInJavadoc(String path, String source, boolean showPositions, String completeBehind, int occurencePosition, int[] ignoreList) throws JavaScriptModelException {
        this.completeInJavadoc(new String[]{path, source}, showPositions, completeBehind, occurencePosition, ignoreList);
    }

    protected void completeInJavadoc(String[] sources, boolean showPositions, String completeBehind) throws JavaScriptModelException {
        this.completeInJavadoc(sources, showPositions, completeBehind, 1, null);
    }

    protected void completeInJavadoc(String[] sources, boolean showPositions, String completeBehind, int occurencePosition) throws JavaScriptModelException {
        this.completeInJavadoc(sources, showPositions, completeBehind, occurencePosition, null);
    }

    protected void completeInJavadoc(String[] sources, boolean showPositions, String completeBehind, int occurencePosition, int[] ignoreList) throws JavaScriptModelException {
        int endPosition;
        char ch;
        int i;
        AbstractJavadocCompletionModelTest.assertNotNull((String)"We should have sources!!!", (Object)sources);
        AbstractJavadocCompletionModelTest.assertTrue((String)"Invalid number of sources!!!", (sources.length % 2 == 0 ? 1 : 0) != 0);
        int length = sources.length / 2;
        this.workingCopies = new IJavaScriptUnit[length];
        int i2 = 0;
        while (i2 < length) {
            this.workingCopies[i2] = this.getWorkingCopy(sources[i2 * 2], sources[i2 * 2 + 1]);
            if (WRITE_DIR != null) {
                this.writeFiles(sources);
            }
            ++i2;
        }
        AbstractJavadocCompletionModelTest.waitUntilIndexesReady();
        this.requestor = new CompletionTestsRequestor2(true, false, showPositions);
        if (ignoreList != null) {
            i2 = 0;
            while (i2 < ignoreList.length) {
                this.requestor.setIgnored(ignoreList[i2], true);
                ++i2;
            }
        }
        String source = this.workingCopies[0].getSource();
        this.replacedText = completeBehind;
        this.completionStart = -1;
        int cursorPos = this.replacedText.length();
        if (occurencePosition < -10) {
            this.completionStart = source.indexOf(this.replacedText);
            cursorPos = -occurencePosition - 10;
        } else if (occurencePosition < 0) {
            this.completionStart = source.lastIndexOf(this.replacedText);
            int max = -occurencePosition;
            i = 1;
            while (i < max) {
                this.completionStart = source.lastIndexOf(this.replacedText, this.completionStart);
                ++i;
            }
        } else {
            this.completionStart = source.indexOf(this.replacedText);
            int shift = this.replacedText.length();
            i = 1;
            while (i < occurencePosition && this.completionStart > 0) {
                this.completionStart = source.indexOf(this.replacedText, this.completionStart + shift);
                ++i;
            }
        }
        AbstractJavadocCompletionModelTest.assertTrue((String)("We should have found " + occurencePosition + " occurence(s) of '" + this.replacedText + "' in:\n" + source), (this.completionStart > 0 ? 1 : 0) != 0);
        this.cursorLocation = this.completionStart + cursorPos;
        this.workingCopies[0].codeComplete(this.cursorLocation, (CompletionRequestor)this.requestor, this.wcOwner);
        this.assertNoProblem(sources[0]);
        if (occurencePosition == 0) {
            this.completionStart = this.cursorLocation;
        }
        if (Character.isJavaIdentifierPart(ch = source.charAt(endPosition = this.cursorLocation)) || ch == '>' || ch == '}' || ch == '(' || ch == ')') {
            while (Character.isJavaIdentifierPart(ch = source.charAt(++endPosition)) || ch == '>' || ch == '}' || ch == '(' || ch == ')') {
            }
        }
        this.positions = "[" + this.completionStart + ", " + endPosition + "], ";
    }

    @Override
    protected String displayString(String toPrint, int indent) {
        String toDisplay = super.displayString(toPrint, indent);
        int openBracket = toDisplay.indexOf(", [");
        if (openBracket > 0) {
            StringBuffer buffer = new StringBuffer();
            int closeBracket = 0;
            while (openBracket > 0) {
                buffer.append(toDisplay.substring(closeBracket, openBracket + 2));
                closeBracket = toDisplay.indexOf("], ", openBracket + 3);
                if (closeBracket < 0) break;
                closeBracket += 3;
                buffer.append("\"+this.positions+");
                int i = 0;
                while (toDisplay.charAt(closeBracket + i) != '}') {
                    ++i;
                }
                try {
                    int relevance = Integer.parseInt(toDisplay.substring(closeBracket, closeBracket + i));
                    int length = RELEVANCES.length;
                    boolean found = false;
                    int r = 0;
                    while (!found && r < length) {
                        if (RELEVANCES[r] == relevance) {
                            buffer.append(RELEVANCES_NAMES[r]);
                            buffer.append("+\"");
                            found = true;
                        }
                        ++r;
                    }
                    if (!found) {
                        buffer.append('\"');
                        buffer.append(relevance);
                    }
                    closeBracket += i;
                }
                catch (NumberFormatException nfe) {
                    System.err.println(String.valueOf(nfe.getMessage()) + " should not occur!");
                }
                openBracket = toDisplay.indexOf(", [", closeBracket);
            }
            if (closeBracket > 0) {
                buffer.append(toDisplay.substring(closeBracket, toDisplay.length()));
                toDisplay = buffer.toString();
            }
        }
        return toDisplay.replaceAll(", 8}", ", \"+JAVADOC_RELEVANCE+\"}");
    }

    protected void setUpProjectOptions(String compliance) throws JavaScriptModelException {
        try {
            this.setUpProjectCompliance(COMPLETION_PROJECT, compliance);
        }
        catch (IOException e) {
            AbstractJavadocCompletionModelTest.assertTrue((String)("Unexpected IOException: " + e.getMessage()), (boolean)false);
        }
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        if (COMPLETION_PROJECT == null) {
            COMPLETION_PROJECT = this.setUpJavaProject("Completion");
            this.createFolder((IPath)new Path("/Completion/src/javadoc/tags"));
        } else {
            this.setUpProjectCompliance(COMPLETION_PROJECT, "1.4");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.requestor = null;
        super.tearDown();
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteFolder((IPath)new Path("/Completion/src/javadoc/tags"));
        super.tearDownSuite();
        if (COMPLETION_SUITES == null) {
            COMPLETION_PROJECT = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void writeFiles(String[] sources) {
        if (AbstractJavadocCompletionModelTest.WRITE_DIR_FILE == null) {
            return;
        }
        testName = this.getName();
        idx = testName.indexOf(" - ");
        if (idx > 0) {
            testName = testName.substring(idx + 3);
        }
        length = sources.length / 2;
        names = new String[length][3];
        i = 0;
        while (i < length) {
            block7: {
                filePath = new Path(sources[2 * i]).removeFirstSegments(2);
                dirPath = filePath.removeLastSegments(1);
                fileDir = dirPath.toString();
                typeName = filePath.removeFileExtension().lastSegment();
                packageDir = new File(AbstractJavadocCompletionModelTest.WRITE_DIR_FILE, fileDir);
                if (AbstractJavadocCompletionModelTest.PACKAGE_FILES.contains(packageDir)) ** GOTO lbl29
                if (!packageDir.exists()) break block7;
                AbstractJavadocCompletionModelTest.PACKAGE_FILES.add(packageDir);
                Util.delete((File)packageDir);
                ** GOTO lbl29
            }
            if (!packageDir.mkdirs()) {
                System.err.println(packageDir + " does not exist and CANNOT be created!!!");
            } else {
                AbstractJavadocCompletionModelTest.PACKAGE_FILES.add(packageDir);
lbl29:
                // 3 sources

                names[i][0] = typeName;
                fileName = typeName.length() <= 3 ? typeName : typeName.substring(0, typeName.length() - 3);
                names[i][1] = fileName = String.valueOf(fileName) + testName.substring(4);
                names[i][2] = String.valueOf(packageDir.getAbsolutePath()) + "\\" + fileName + ".js";
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            contents = sources[2 * i + 1];
            j = 0;
            while (j < length) {
                contents = contents.replaceAll(names[j][0], names[j][1]);
                ++j;
            }
            fullPathName = names[i][2];
            System.out.println("Write file " + fullPathName);
            Util.writeToFile((String)contents, (String)fullPathName);
            ++i;
        }
    }
}

