/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.properties;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.core.internal.utility.ICUStringCollator;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.properties.JptProjectPropertiesPage;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbPreferences;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;
import org.eclipse.jpt.jaxb.ui.JaxbWorkbench;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.properties.JaxbProjectModel;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxbProjectPropertiesPage
extends JptProjectPropertiesPage {
    public static final String PROP_ID = "org.eclipse.jpt.jaxb.ui.jaxbProjectPropertiesPage";
    private PropertyValueModel<JaxbProject> jaxbProjectModel;
    private BufferedModifiablePropertyValueModel<JaxbPlatformConfig> platformModel;
    private PropertyChangeListener platformListener;
    static final Comparator<String> STRING_COMPARATOR = new ICUStringCollator();
    private static final Comparator<JaxbPlatformConfig> JAXB_PLATFORM_CONFIG_COMPARATOR = new Comparator<JaxbPlatformConfig>(){

        @Override
        public int compare(JaxbPlatformConfig desc1, JaxbPlatformConfig desc2) {
            return STRING_COMPARATOR.compare(desc1.getLabel(), desc2.getLabel());
        }
    };

    protected void buildModels() {
        this.jaxbProjectModel = new JaxbProjectModel((PropertyValueModel<IProject>)this.projectModel);
        this.platformModel = this.buildPlatformModel();
        this.platformListener = this.buildPlatformListener();
    }

    private BufferedModifiablePropertyValueModel<JaxbPlatformConfig> buildPlatformModel() {
        return new BufferedModifiablePropertyValueModel((ModifiablePropertyValueModel)new PlatformModel(this.jaxbProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyChangeListener buildPlatformListener() {
        return new PlatformListener();
    }

    void platformChanged() {
        if (!this.getControl().isDisposed()) {
            this.adjustLibraryProviders();
        }
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        return this.getFacetedProject().getInstalledVersion(JaxbProject.FACET);
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)project, fv);
        lid.addListener(this.buildLibraryProviderListener(), new String[0]);
        return lid;
    }

    protected void adjustLibraryProviders() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid != null) {
            ArrayList<JaxbLibraryProviderInstallOperationConfig> jaxbConfigs = new ArrayList<JaxbLibraryProviderInstallOperationConfig>();
            JaxbLibraryProviderInstallOperationConfig currentJaxbConfig = null;
            LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
            if (config instanceof JaxbLibraryProviderInstallOperationConfig) {
                currentJaxbConfig = (JaxbLibraryProviderInstallOperationConfig)config;
                jaxbConfigs.add(currentJaxbConfig);
            }
            for (ILibraryProvider lp : lid.getLibraryProviders()) {
                config = lid.getLibraryProviderOperationConfig(lp);
                if (!(config instanceof JaxbLibraryProviderInstallOperationConfig) || config.equals(currentJaxbConfig)) continue;
                jaxbConfigs.add((JaxbLibraryProviderInstallOperationConfig)config);
            }
            for (JaxbLibraryProviderInstallOperationConfig jaxbConfig : jaxbConfigs) {
                jaxbConfig.setJaxbPlatformConfig((JaxbPlatformConfig)this.platformModel.getValue());
            }
        }
    }

    protected void createWidgets(Composite parent) {
        this.buildPlatformGroup(parent);
        Control libraryProviderComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)parent, (LibraryInstallDelegate)this.getLibraryInstallDelegate(), (String)JptJaxbUiMessages.JAXB_FACET_WIZARD_PAGE_JAXB_IMPLEMENTATION_LABEL);
        libraryProviderComposite.setLayoutData((Object)new GridData(768));
    }

    protected void engageListeners_() {
        super.engageListeners_();
        this.platformModel.addPropertyChangeListener("value", this.platformListener);
    }

    public void disengageListeners_() {
        this.platformModel.removePropertyChangeListener("value", this.platformListener);
        super.disengageListeners_();
    }

    private void buildPlatformGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJaxbUiMessages.JAXB_FACET_WIZARD_PAGE_PLATFORM_LABEL);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Combo platformDropDown = this.buildDropDown((Composite)group);
        SWTBindingTools.bindDropDownListBox(this.buildPlatformChoicesModel(), this.platformModel, (Combo)platformDropDown, (Transformer)JaxbPlatformConfig.LABEL_TRANSFORMER);
        this.buildFacetsPageLink((Composite)group, JptJaxbUiMessages.JAXB_FACET_WIZARD_PAGE_FACETS_PAGE_LINK);
    }

    private ListValueModel<JaxbPlatformConfig> buildPlatformChoicesModel() {
        return new SortedListValueModelAdapter((CollectionValueModel)new SetCollectionValueModel((CollectionValueModel)CompositeCollectionValueModel.forModels((CollectionValueModel[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.platformModel), this.buildRegistryPlatformsModel()})), JAXB_PLATFORM_CONFIG_COMPARATOR);
    }

    private CollectionValueModel<JaxbPlatformConfig> buildRegistryPlatformsModel() {
        Iterable enabledPlatforms = IterableTools.filter(this.getJaxbPlatformConfigs(), (Predicate)new JaxbPlatformConfig.SupportsJaxbFacetVersion(this.getProjectFacetVersion()));
        return new StaticCollectionValueModel(enabledPlatforms);
    }

    private Iterable<JaxbPlatformConfig> getJaxbPlatformConfigs() {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager != null ? jaxbPlatformManager.getJaxbPlatformConfigs() : IterableTools.emptyIterable();
    }

    protected boolean projectRebuildRequired() {
        return this.platformModel.isBuffering();
    }

    protected void rebuildProject() {
        JaxbProjectManager jaxbProjectManager = this.getJaxbProjectManager();
        if (jaxbProjectManager != null) {
            jaxbProjectManager.rebuildJaxbProject(this.getProject());
        }
    }

    protected BufferedModifiablePropertyValueModel<?>[] buildBufferedModels() {
        return new BufferedModifiablePropertyValueModel[]{this.platformModel};
    }

    private JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    private JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        JaxbWorkbench jaxbWorkbench = this.getJaxbWorkbench();
        return jaxbWorkbench == null ? null : jaxbWorkbench.getJaxbWorkspace();
    }

    private JaxbWorkbench getJaxbWorkbench() {
        return (JaxbWorkbench)WorkbenchTools.getAdapter(JaxbWorkbench.class);
    }

    protected Model[] buildValidationModels() {
        return new Model[]{this.platformModel};
    }

    protected void performValidation(Map<Integer, ArrayList<IStatus>> statuses) {
    }

    class PlatformListener
    extends PropertyChangeAdapter {
        PlatformListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JaxbProjectPropertiesPage.this.platformChanged();
        }
    }

    static class PlatformModel
    extends AspectPropertyValueModelAdapter<JaxbProject, JaxbPlatformConfig> {
        PlatformModel(PropertyValueModel<JaxbProject> jaxbProjectModel) {
            super(jaxbProjectModel);
        }

        protected JaxbPlatformConfig buildValue_() {
            return ((JaxbProject)this.subject).getPlatform().getConfig();
        }

        public void setValue_(JaxbPlatformConfig newPlatform) {
            JaxbPreferences.setJaxbPlatformID((IProject)((JaxbProject)this.subject).getProject(), (String)newPlatform.getId());
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }
}

