/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJarsProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AvailableUtilityJarsProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    public Object[] getElements(Object inputElement) {
        Object[] array = this.getJarFilesFromDirectory(inputElement);
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                return AvailableUtilityJarsProvider.this.getColumnText(o1, 0).compareTo(AvailableUtilityJarsProvider.this.getColumnText(o2, 0));
            }
        });
        return array;
    }

    private Object[] getJarFilesFromDirectory(Object inputElement) {
        String fileName;
        File directory;
        ArrayList<File> collectedJars = new ArrayList<File>();
        IDataModel model = null;
        if (inputElement instanceof IDataModel) {
            model = (IDataModel)inputElement;
        }
        if (model != null && (directory = new File(fileName = model.getStringProperty("J2EEUtilityJarListImportDataModel.AVAILABLE_JARS_DIRECTORY"))).exists() && directory.canRead() && directory.isDirectory()) {
            File[] availableFiles = directory.listFiles();
            if (availableFiles == null) {
                return new File[0];
            }
            int i = 0;
            while (i < availableFiles.length) {
                if (availableFiles[i] != null && availableFiles[i].getName().endsWith(".jar")) {
                    collectedJars.add(availableFiles[i]);
                }
                ++i;
            }
        }
        return collectedJars.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return AvailableJarsProvider.getUtilImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        return element.toString();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

