/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;

class JavaClassWizardPage
extends NewClassWizardPage {
    private String _className;
    private final IProject _project;
    private final InitialClassProperties _initialValues;
    private IJavaProject _javaProject;
    private IStatus _fClassNameStatus;
    private IStatus _fPackageNameStatus;
    private static final String SOURCE_COMPLIANCE_1_3 = "1.3";

    public JavaClassWizardPage(IProject project, String className, String superClassName, List interfacesName) {
        this._className = className;
        this._project = project;
        try {
            this._javaProject = project != null && project.hasNature("org.eclipse.jdt.core.javanature") ? JavaCore.create((IProject)project) : null;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this._initialValues = new InitialClassProperties();
        this._initialValues.className = className;
        this._initialValues.superClassName = superClassName;
        this._initialValues.interfacesName = interfacesName;
    }

    public JavaClassWizardPage(IProject project, String className) {
        this(project, className, null, null);
    }

    public void init() {
        this.initializeExpectedValues();
        this.initializeWizardPage();
    }

    private void initializeExpectedValues() {
        int loc = this._className.indexOf(":");
        if (loc != -1) {
            if (loc < this._className.length()) {
                this._initialValues.classArgs = this._className.substring(loc + 1, this._className.length());
                this._className = this._className.substring(0, loc);
            }
            if (loc > 0) {
                this._initialValues.className = this._className.substring(0, loc);
            } else if (loc == 0) {
                this._initialValues.className = "";
            }
        }
        this._fClassNameStatus = JavaConventions.validateJavaTypeName((String)this._initialValues.className, (String)SOURCE_COMPLIANCE_1_3, (String)SOURCE_COMPLIANCE_1_3);
        loc = this._className.lastIndexOf(46);
        if (loc != -1) {
            this._initialValues.packageName = this._className.substring(0, loc);
            this._initialValues.className = this._className.substring(loc + 1);
            this._fPackageNameStatus = JavaConventions.validateJavaTypeName((String)this._initialValues.packageName, (String)SOURCE_COMPLIANCE_1_3, (String)SOURCE_COMPLIANCE_1_3);
            this._fClassNameStatus = JavaConventions.validateJavaTypeName((String)this._initialValues.className, (String)SOURCE_COMPLIANCE_1_3, (String)SOURCE_COMPLIANCE_1_3);
        }
        if (this._javaProject == null) {
            return;
        }
        try {
            if (this._initialValues.packageFragmentRoot == null) {
                IPackageFragmentRoot srcEntryDft = null;
                IPackageFragmentRoot[] roots = this._javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        srcEntryDft = roots[i];
                        break;
                    }
                    ++i;
                }
                if (srcEntryDft != null) {
                    this._initialValues.packageFragmentRoot = srcEntryDft;
                } else {
                    this._initialValues.packageFragmentRoot = this._javaProject.getPackageFragmentRoot(this._javaProject.getResource());
                }
                if (this._initialValues.packageFragment == null && this._initialValues.packageFragmentRoot != null && this._initialValues.packageName != null && this._initialValues.packageName.length() > 0) {
                    IFolder packageFolder = this._project.getFolder(this._initialValues.packageName);
                    this._initialValues.packageFragment = this._initialValues.packageFragmentRoot.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
                }
            }
            if (this._initialValues.superClassName == null) {
                this._initialValues.superClassName = "java.lang.Object";
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected void initializeWizardPage() {
        this.setPackageFragmentRoot(this._initialValues.packageFragmentRoot, true);
        this.setPackageFragment(this._initialValues.packageFragment, true);
        this.setEnclosingType(null, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(this._initialValues.className, true);
        this.setSuperClass(this._initialValues.superClassName, true);
        if (this._initialValues.interfacesName != null) {
            this.setSuperInterfaces(this._initialValues.interfacesName, true);
        }
        boolean hasSuperClass = this._initialValues.superClassName != null && this._initialValues.superClassName.length() > 0;
        boolean hasInterface = this._initialValues.interfacesName != null && this._initialValues.interfacesName.size() > 0;
        this.setMethodStubSelection(false, hasSuperClass, hasInterface || hasSuperClass, true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._fClassNameStatus != null && !this._fClassNameStatus.isOK()) {
            this.updateStatus(this._fClassNameStatus);
        }
        if (this._fPackageNameStatus != null && !this._fPackageNameStatus.isOK()) {
            this.updateStatus(this._fPackageNameStatus);
        }
    }

    public String getClassArgs() {
        if (this._initialValues.classArgs == null) {
            return "";
        }
        return this._initialValues.classArgs;
    }

    static class InitialClassProperties {
        private String superClassName = "";
        private List interfacesName = null;
        private String className = null;
        private String classArgs = null;
        private String packageName = null;
        private IPackageFragmentRoot packageFragmentRoot = null;
        private IPackageFragment packageFragment = null;

        InitialClassProperties() {
        }
    }
}

