/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.util;

import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;

public class ModelUtil {
    private static final String ENTITY_NEWLINE = "&#xA;";
    private static final String ENTITY_TAB = "&#x9;";
    private static final String ENTITY_CARRIAGE_RETURN = "&#xD;";
    private static final String ENTITY_AMPERSAND = "&amp;";
    private static final String ENTITY_DOUBLE_QUOTE = "&quot;";
    private static final String ENTITY_SINGLE_QUOTE = "&apos;";
    private static final String ENTITY_GREATER_THAN = "&gt;";
    private static final String ENTITY_LESS_THAN = "&lt;";

    public static String getSuperType(Object key) {
        if (key == FacesConfigPackage.eINSTANCE.getActionListenerType()) {
            return "javax.faces.event.ActionListener";
        }
        if (key == FacesConfigPackage.eINSTANCE.getNavigationHandlerType()) {
            return "javax.faces.application.NavigationHandler";
        }
        if (key == FacesConfigPackage.eINSTANCE.getPropertyResolverType()) {
            return "javax.faces.el.PropertyResolver";
        }
        if (key == FacesConfigPackage.eINSTANCE.getStateManagerType()) {
            return "javax.faces.application.StateManager";
        }
        if (key == FacesConfigPackage.eINSTANCE.getVariableResolverType()) {
            return "javax.faces.el.VariableResolver";
        }
        if (key == FacesConfigPackage.eINSTANCE.getViewHandlerType()) {
            return "javax.faces.application.ViewHandler";
        }
        if (key == FacesConfigPackage.eINSTANCE.getApplicationFactoryType()) {
            return "javax.faces.application.ApplicationFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getFacesContextFactoryType()) {
            return "javax.faces.context.FacesContextFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getLifecycleFactoryType()) {
            return "javax.faces.lifecycle.LifecycleFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getRenderKitFactoryType()) {
            return "javax.faces.render.RenderKitFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getPhaseListenerType()) {
            return "javax.faces.event.PhaseListener";
        }
        return null;
    }

    public static String escapeEntities(String str) {
        if (ModelUtil.isEmptyString(str)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        int n = str.length();
        while (i < n) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = ENTITY_LESS_THAN;
                    break;
                }
                case '>': {
                    entity = ENTITY_GREATER_THAN;
                    break;
                }
                case '\'': {
                    entity = ENTITY_SINGLE_QUOTE;
                    break;
                }
                case '\"': {
                    entity = ENTITY_DOUBLE_QUOTE;
                    break;
                }
                case '&': {
                    entity = ENTITY_AMPERSAND;
                    break;
                }
                case '\r': {
                    entity = ENTITY_CARRIAGE_RETURN;
                    break;
                }
                case '\t': {
                    entity = ENTITY_TAB;
                    break;
                }
                case '\n': {
                    entity = ENTITY_NEWLINE;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity != null) {
                    buffer = new StringBuffer(str.length() + 20);
                    buffer.append(str.substring(0, i));
                    buffer.append(entity);
                }
            } else if (entity == null) {
                buffer.append(ch);
            } else {
                buffer.append(entity);
            }
            ++i;
        }
        return buffer == null ? str : buffer.toString();
    }

    public static String unEscapeEntities(String str) {
        if (ModelUtil.isEmptyString(str)) {
            return "";
        }
        String result = new String(str);
        result = result.replaceAll(ENTITY_AMPERSAND, "&");
        result = result.replaceAll(ENTITY_LESS_THAN, "<");
        result = result.replaceAll(ENTITY_GREATER_THAN, ">");
        result = result.replaceAll(ENTITY_SINGLE_QUOTE, "'");
        result = result.replaceAll(ENTITY_DOUBLE_QUOTE, "\"");
        result = result.replaceAll(ENTITY_CARRIAGE_RETURN, "\r");
        result = result.replaceAll(ENTITY_TAB, "\t");
        result = result.replaceAll(ENTITY_NEWLINE, "\n");
        return result;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }
}

