/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.pagedesigner.meta.EditorCreator;
import org.eclipse.jst.pagedesigner.properties.ITabbedPropertiesConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class PropertyDescriptorWrapper
implements IPropertyDescriptor {
    private IPropertyDescriptor _inner;
    private IDOMElement _element;
    private IStatusLineManager _statusLineManager;

    public PropertyDescriptorWrapper(IDOMElement element, IPropertyDescriptor innerDescriptor) {
        this._element = element;
        this._inner = innerDescriptor;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        EditorCreator.CellEditorHolder holder = new EditorCreator.CellEditorHolder(){

            public CellEditor createCellEditor(Composite parent1) {
                Object ed = null;
                ed = PropertyDescriptorWrapper.this._inner != null ? PropertyDescriptorWrapper.this._inner.createPropertyEditor(parent1) : new TextCellEditor(parent1);
                if (PropertyDescriptorWrapper.this._statusLineManager != null) {
                    ed.addListener((ICellEditorListener)new StatusBarUpdater((CellEditor)ed));
                }
                return ed;
            }
        };
        return EditorCreator.getInstance().createCellEditorWithWrapper(parent, null, holder, this._element, null);
    }

    public String getCategory() {
        String cat = this._inner.getCategory();
        return cat != null ? cat : ITabbedPropertiesConstants.OTHER_CATEGORY;
    }

    public String getDescription() {
        return this._inner.getDescription();
    }

    public String getDisplayName() {
        return this._inner.getDisplayName();
    }

    public String[] getFilterFlags() {
        return this._inner.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this._inner.getHelpContextIds();
    }

    public Object getId() {
        return this._inner.getId();
    }

    public ILabelProvider getLabelProvider() {
        return this._inner.getLabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        if (anotherProperty instanceof PropertyDescriptorWrapper) {
            return this._inner.isCompatibleWith(((PropertyDescriptorWrapper)anotherProperty).getInner());
        }
        return this._inner.isCompatibleWith(anotherProperty);
    }

    public IPropertyDescriptor getInner() {
        return this._inner;
    }

    private class StatusBarUpdater
    implements ICellEditorListener {
        private CellEditor ed;

        StatusBarUpdater(CellEditor ed) {
            this.ed = ed;
        }

        public void applyEditorValue() {
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                PropertyDescriptorWrapper.this._statusLineManager.setErrorMessage(this.ed.getErrorMessage());
            } else {
                PropertyDescriptorWrapper.this._statusLineManager.setErrorMessage(null);
            }
        }
    }
}

