/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal;

import java.net.SocketAddress;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.JavascriptVmFactory;
import org.eclipse.wst.jsdt.chromium.StandaloneVm;
import org.eclipse.wst.jsdt.chromium.internal.standalonev8.StandaloneVmImpl;
import org.eclipse.wst.jsdt.chromium.internal.transport.Connection;
import org.eclipse.wst.jsdt.chromium.internal.transport.Handshaker;
import org.eclipse.wst.jsdt.chromium.internal.transport.SocketConnection;

public class JavascriptVmFactoryImpl
extends JavascriptVmFactory {
    public static final JavascriptVmFactoryImpl INSTANCE = new JavascriptVmFactoryImpl();
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 1000;

    @Override
    public StandaloneVm createStandalone(SocketAddress socketAddress, ConnectionLogger connectionLogger) {
        Handshaker.StandaloneV8Impl handshaker = new Handshaker.StandaloneV8Impl();
        SocketConnection connection = new SocketConnection(socketAddress, this.getTimeout(), connectionLogger, handshaker);
        return this.createStandalone(connection, handshaker);
    }

    StandaloneVmImpl createStandalone(Connection connection, Handshaker.StandaloneV8 handshaker) {
        return new StandaloneVmImpl(connection, handshaker);
    }

    private int getTimeout() {
        String timeoutString = System.getProperty("org.eclipse.wst.jsdt.chromium.client.connection.timeoutMs", String.valueOf(1000));
        int timeoutMs = 1000;
        try {
            timeoutMs = Integer.parseInt(timeoutString);
        }
        catch (NumberFormatException numberFormatException) {}
        return timeoutMs;
    }
}

