/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.annotations;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;

public class AnnotationFactoryTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void testCreateStringValue() {
        try {
            AnnotationFactory.createStringValue(null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        IValue strValue = AnnotationFactory.createStringValue((String)"value");
        AnnotationFactoryTest.assertNotNull((Object)strValue);
        AnnotationFactoryTest.assertTrue((boolean)strValue.toString().equals("value"));
    }

    public void testCreateParamValuePair() {
        IValue strValue = AnnotationFactory.createStringValue((String)"value");
        try {
            AnnotationFactory.createParamValuePairValue(null, (IValue)strValue);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            AnnotationFactory.createParamValuePairValue((String)"", null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
            AnnotationFactoryTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        IParamValuePair valuePair = AnnotationFactory.createParamValuePairValue((String)"param", (IValue)strValue);
        AnnotationFactoryTest.assertNotNull((Object)valuePair);
        AnnotationFactoryTest.assertTrue((boolean)(valuePair.getValue() instanceof IValue));
        AnnotationFactoryTest.assertTrue((boolean)valuePair.getParam().equals("param"));
    }

    public void testCreateComplexAnnotation() throws Exception {
        IValue strValue1 = AnnotationFactory.createStringValue((String)"value");
        IParamValuePair valuePair1 = AnnotationFactory.createParamValuePairValue((String)"param", (IValue)strValue1);
        IValue strValue2 = AnnotationFactory.createStringValue((String)"value1");
        IParamValuePair valuePair2 = AnnotationFactory.createParamValuePairValue((String)"param1", (IValue)strValue2);
        HashSet<IParamValuePair> paramValues = new HashSet<IParamValuePair>();
        paramValues.add(valuePair1);
        paramValues.add(valuePair2);
        try {
            AnnotationFactory.createAnnotation(null, paramValues, (IJavaElement)this.endpoint);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            AnnotationFactory.createAnnotation((String)"", null, (IJavaElement)this.endpoint);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
            AnnotationFactoryTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.prepareProject();
        IAnnotation ca = AnnotationFactory.createAnnotation((String)"name", paramValues, (IJavaElement)this.endpoint);
        AnnotationFactoryTest.assertNotNull((Object)ca);
        AnnotationFactoryTest.assertEquals((int)ca.getParamValuePairs().size(), (int)2);
    }

    public void testCreateValuePair() {
        try {
            AnnotationFactory.createParamValuePairValue((String)"", null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
            AnnotationFactoryTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            AnnotationFactory.createParamValuePairValue(null, null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testCreateArrayValue() {
        try {
            AnnotationFactory.createArrayValue(null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        IValue strValue1 = AnnotationFactory.createStringValue((String)"value1");
        IValue strValue2 = AnnotationFactory.createStringValue((String)"value2");
        LinkedHashSet<IValue> values = new LinkedHashSet<IValue>();
        values.add(strValue1);
        values.add(strValue2);
        IValue arrValue = AnnotationFactory.createArrayValue(values);
        AnnotationFactoryTest.assertNotNull((Object)arrValue);
        AnnotationFactoryTest.assertTrue((boolean)arrValue.toString().equals("[value1, value2]"));
    }

    public void testCreateQualifiedNameValue() {
        try {
            AnnotationFactory.createQualifiedNameValue(null);
            AnnotationFactoryTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        IValue qName = AnnotationFactory.createQualifiedNameValue((String)"org.eclipse.demo.Test");
        AnnotationFactoryTest.assertNotNull((Object)qName);
        AnnotationFactoryTest.assertTrue((boolean)qName.toString().equals("org.eclipse.demo.Test"));
    }

    public void testCreateBooleanValue() {
        IValue boolValue = AnnotationFactory.createBooleanValue((boolean)true);
        AnnotationFactoryTest.assertNotNull((Object)boolValue);
        AnnotationFactoryTest.assertEquals((String)boolValue.toString(), (String)"true");
    }

    public void testGetAnnotationsFromClass() throws Exception {
        this.prepareProject();
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationFactoryTest.assertNotNull((Object)annotations);
        AnnotationFactoryTest.assertTrue((annotations.size() == 2 ? 1 : 0) != 0);
    }

    public void testGetAnnotationsFromMethod() throws Exception {
        this.prepareProject();
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
        AnnotationFactoryTest.assertNotNull((Object)annotations);
        AnnotationFactoryTest.assertTrue((annotations.size() == 1 ? 1 : 0) != 0);
    }

    public void testRemoveAnnotationsIType() throws Exception {
        this.prepareProject();
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationFactoryTest.assertTrue((annotations.size() == 0 ? 1 : 0) != 0);
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
        AnnotationFactoryTest.assertTrue((annotations.size() == 0 ? 1 : 0) != 0);
    }

    public void testRemoveAnnotationsITypeSetOfString() throws Exception {
        this.prepareProject();
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("WebService");
        toRemove.add("WebMethod");
        AnnotationFactory.removeAnnotations((IJavaElement)this.endpoint, toRemove);
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationFactoryTest.assertTrue((annotations.size() == 1 ? 1 : 0) != 0);
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        Collection annotationsMethod = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
        AnnotationFactoryTest.assertTrue((annotationsMethod.size() == 0 ? 1 : 0) != 0);
    }

    public void testRemoveAnnotationsIField() throws Exception {
        this.prepareProject();
        IField field = this.endpoint.getField("field1");
        AnnotationFactoryTest.assertNotNull((Object)field);
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)field);
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationFactoryTest.assertTrue((annotations.size() == 2 ? 1 : 0) != 0);
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        Collection annotationsMethod = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
        AnnotationFactoryTest.assertTrue((annotationsMethod.size() == 1 ? 1 : 0) != 0);
    }

    public void testRemoveAnnotationsIMethod() throws Exception {
        this.prepareProject();
        IMethod method = this.endpoint.getMethod("annotatedMethod", new String[]{"QString;"});
        this.endpoint.getField("field1");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)method);
        Collection annotations = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        AnnotationFactoryTest.assertTrue((annotations.size() == 2 ? 1 : 0) != 0);
        Collection annotationsMethod = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectMethod(method);
        AnnotationFactoryTest.assertTrue((annotationsMethod.size() == 0 ? 1 : 0) != 0);
    }

    private void prepareProject() throws Exception {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
    }
}

