/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import junit.framework.TestCase;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.DomTestUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public abstract class SerializerAdapterTestFixture
extends TestCase {
    protected static final String WS_ANNOTATION = "javax.jws.WebService";
    protected static final String SERVICE_NAME = "MyService";
    protected static final String PORT_TYPE_NAME = "MyPortType";
    protected static final String PORT_NAME = "MyPort";
    protected static final String TARGET_NAMESPACE = "http://com.sap/test";
    protected static final String WSDL_LOCATION = "C:/test/wsdl/location";
    protected IWebService ws;
    protected IWebService wsImplicit;
    protected IServiceEndpointInterface sei;
    protected TestProject project;
    protected IType implBeanType;
    protected IType implBeanImplicit;
    protected IType seiType;
    protected IWebServiceProject wsProject;
    protected JaxWsWorkspaceResource resource;
    protected DomTestUtils testUtil = new DomTestUtils();
    protected DomUtil domUtil = new DomUtil();

    public void setUp() throws Exception {
        this.project = new TestProject();
        IPackageFragment pack = this.project.createSourceFolder("src").createPackageFragment("test", true, null);
        this.seiType = this.project.createType(pack, "SEI.java", "@javax.jws.WebService(name=\"MyPortType\", targetNamespace=\"http://com.sap/test\")\npublic interface SEI {}");
        this.implBeanType = this.project.createType(pack, "ImplBean.java", "@javax.jws.WebService(endpointInterface=\"test.SEI\", serviceName=\"MyService\", portName=\"MyPort\", wsdlLocation=\"C:/test/wsdl/location\", targetNamespace=\"http://com.sap/test\")public class ImplBean {}");
        this.implBeanImplicit = this.project.createType(pack, "ImplicitImplBean.java", "@javax.jws.WebService(name=\"ImplicitName\", serviceName=\"MyService\", portName=\"MyPort\", wsdlLocation=\"C:/test/wsdl/location\", targetNamespace=\"http://com.sap/test\")public class ImplicitImplBean {}");
        SerializerAdapterTestFixture.assertNotNull((Object)this.seiType);
        SerializerAdapterTestFixture.assertNotNull((Object)this.implBeanType);
        this.resource = this.createTarget();
        this.resource.load(null);
        this.wsProject = (IWebServiceProject)this.resource.getDOM().getWebServiceProjects().get(0);
        this.sei = this.domUtil.findSeiByImplName(this.wsProject, "test.SEI");
        this.ws = this.domUtil.findWsByImplName(this.wsProject, "test.ImplBean");
        this.wsImplicit = this.domUtil.findWsByImplName(this.wsProject, "test.ImplicitImplBean");
    }

    public void tearDown() {
        try {
            this.project.dispose();
        }
        catch (Exception exception) {}
    }

    private JaxWsWorkspaceResource createTarget() {
        return new JaxWsWorkspaceResource(this.project.getJavaProject().getJavaModel()){

            public boolean approveProject(IJavaProject prj) {
                return prj.getElementName().equals(SerializerAdapterTestFixture.this.project.getJavaProject().getElementName());
            }
        };
    }
}

