/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.properties.ConfigurablePropertySheetPage;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;

public class TestPropertySheetConfiguration
extends TestCase {
    private final String PROJECT_NAME = "TestPropertySheetConfiguration";
    private final String FILE_NAME = "testPropertySheetConfiguration.xml";
    private static StructuredTextEditor fEditor;
    private static IEditorPart fMainEditor;
    private static IFile fFile;
    private static boolean fIsSetup;

    static {
        fIsSetup = false;
    }

    public TestPropertySheetConfiguration() {
        super("TestPropertySheetConfiguration");
    }

    protected void setUp() throws Exception {
        if (!fIsSetup) {
            this.createProject("TestPropertySheetConfiguration");
            fFile = this.getOrCreateFile("TestPropertySheetConfiguration/testPropertySheetConfiguration.xml");
            fIsSetup = true;
        }
        if (fIsSetup && fMainEditor == null) {
            Object adapter;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            fMainEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)fFile, (boolean)true, (boolean)true);
            if (fMainEditor instanceof StructuredTextEditor) {
                fEditor = (StructuredTextEditor)fMainEditor;
            } else if (fMainEditor != null && (adapter = fMainEditor.getAdapter(ITextEditor.class)) instanceof StructuredTextEditor) {
                fEditor = (StructuredTextEditor)adapter;
            }
            if (fEditor == null) {
                TestPropertySheetConfiguration.assertTrue((String)("Unable to open structured text editor " + (fMainEditor != null ? fMainEditor.getClass().getName() : "")), (boolean)false);
            }
        }
    }

    protected void tearDown() throws Exception {
        if (fMainEditor != null) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            page.closeEditor(fMainEditor, false);
            TestPropertySheetConfiguration.assertTrue((String)"Unable to close editor", (boolean)true);
            fMainEditor = null;
            fEditor = null;
        }
    }

    private void createProject(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IFile getOrCreateFile(String filePath) {
        IFile blankFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankFile != null && !blankFile.exists()) {
            try {
                blankFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankFile;
    }

    public void testPropertySourceRemoval() throws BadLocationException {
        IDocument document = (IDocument)fEditor.getAdapter(IDocument.class);
        document.replace(0, 0, "<test><myproperty props=\"yes\" /></test>");
        TextSelection setSelection = new TextSelection(9, 0);
        fEditor.getSelectionProvider().setSelection((ISelection)setSelection);
        Object item = null;
        ISelection selection = fEditor.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            item = ((IStructuredSelection)selection).getFirstElement();
            IPropertySheetPage propertySheet = (IPropertySheetPage)fEditor.getAdapter(IPropertySheetPage.class);
            TestPropertySheetConfiguration.assertTrue((String)"No ConfigurablePropertySheetPage found", (boolean)(propertySheet instanceof ConfigurablePropertySheetPage));
            if (propertySheet instanceof ConfigurablePropertySheetPage) {
                ConfigurablePropertySheetPage cps = (ConfigurablePropertySheetPage)propertySheet;
                PropertySheetConfiguration config = cps.getConfiguration();
                TestPropertySheetConfiguration.assertNotNull((String)"No property sheet configuration found", (Object)config);
                IPropertySourceProvider provider = config.getPropertySourceProvider((IPropertySheetPage)cps);
                TestPropertySheetConfiguration.assertNotNull((String)"No property sheet provider found", (Object)provider);
                IPropertySource source = provider.getPropertySource(item);
                if (source instanceof IPropertySourceExtension) {
                    boolean canRemove = ((IPropertySourceExtension)source).isPropertyRemovable((Object)"props");
                    TestPropertySheetConfiguration.assertTrue((String)"Current property cannot be removed", (boolean)canRemove);
                    if (canRemove) {
                        ((IPropertySourceExtension)source).removeProperty((Object)"props");
                        TestPropertySheetConfiguration.assertTrue((String)"Current property cannot be removed", (boolean)true);
                        return;
                    }
                }
            }
        }
        TestPropertySheetConfiguration.assertTrue((String)"testPropertySourceRemoval test did not take expected path", (boolean)false);
    }
}

