/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.errorcustomization;

import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ElementInformation;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationRegistry;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationRegistryWrapper;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.IErrorMessageCustomizer;

public class ErrorCustomizationRegistryTest
extends TestCase {
    private ErrorCustomizationRegistry registry = null;

    protected void setUp() throws Exception {
        this.registry = new ErrorCustomizationRegistryWrapper();
        super.setUp();
    }

    public void testAddErrorMessageCustomizerToRegistry() {
        String namespace1 = "http://namespace1";
        IErrorMessageCustomizer customizer = new IErrorMessageCustomizer(){

            public String customizeMessage(ElementInformation elementInfo, String errorKey, Object[] arguments) {
                return null;
            }
        };
        this.registry.addErrorMessageCustomizer(namespace1, customizer);
        IErrorMessageCustomizer[] registeredCustomizers = this.registry.getCustomizers(namespace1);
        ErrorCustomizationRegistryTest.assertEquals((String)("1. There should only be 1 customizer registered for the namespace but there are " + registeredCustomizers.length), (int)1, (int)registeredCustomizers.length);
        ErrorCustomizationRegistryTest.assertEquals((String)"1. The IErrorMessageCustomizer returned is not the same one registered.", (Object)customizer, (Object)registeredCustomizers[0]);
        IErrorMessageCustomizer customizer2 = new IErrorMessageCustomizer(){

            public String customizeMessage(ElementInformation elementInfo, String errorKey, Object[] arguments) {
                return null;
            }
        };
        this.registry.addErrorMessageCustomizer(namespace1, customizer2);
        registeredCustomizers = this.registry.getCustomizers(namespace1);
        ErrorCustomizationRegistryTest.assertEquals((String)("2. There should be 2 customizers registered for the namespace but there are " + registeredCustomizers.length), (int)2, (int)registeredCustomizers.length);
        ErrorCustomizationRegistryTest.assertEquals((String)"2. The first IErrorMessageCustomizer returned is not the same one registered.", (Object)customizer, (Object)registeredCustomizers[0]);
        ErrorCustomizationRegistryTest.assertEquals((String)"2. The second IErrorMessageCustomizer returned is not the same one registered.", (Object)customizer2, (Object)registeredCustomizers[1]);
        this.registry.addErrorMessageCustomizer(null, customizer);
        registeredCustomizers = this.registry.getCustomizers("");
        ErrorCustomizationRegistryTest.assertEquals((String)("3. There should be 1 customizers registered for the namespace but there are " + registeredCustomizers.length), (int)1, (int)registeredCustomizers.length);
        ErrorCustomizationRegistryTest.assertEquals((String)"3. The IErrorMessageCustomizer returned is not the same one registered.", (Object)customizer, (Object)registeredCustomizers[0]);
    }

    public void testGetCustomizers() {
        IErrorMessageCustomizer[] customizers = this.registry.getCustomizers("http://nonregisterednamespace");
        ErrorCustomizationRegistryTest.assertEquals((String)"1. The array of customizers for an unregistered namespace is not empty.", (int)0, (int)customizers.length);
        IErrorMessageCustomizer customizer = new IErrorMessageCustomizer(){

            public String customizeMessage(ElementInformation elementInfo, String errorKey, Object[] arguments) {
                return null;
            }
        };
        this.registry.addErrorMessageCustomizer(null, customizer);
        customizers = this.registry.getCustomizers(null);
        ErrorCustomizationRegistryTest.assertEquals((String)"2. The array of customizers for a registered customizer for the null namespace does not contain 1 customizer.", (int)1, (int)customizers.length);
        ErrorCustomizationRegistryTest.assertEquals((String)"2. The customizer for the null namespace was not successfully returned.", (Object)customizer, (Object)customizers[0]);
        customizers = this.registry.getCustomizers("");
        ErrorCustomizationRegistryTest.assertEquals((String)"3. The array of customizers for a registered customizer for the null namespace does not contain 1 customizer for the empty string namespace.", (int)1, (int)customizers.length);
        ErrorCustomizationRegistryTest.assertEquals((String)"3. The customizer for the empty string namespace was not successfully returned.", (Object)customizer, (Object)customizers[0]);
    }
}

