/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationBaseImpl<T extends IJavaElement>
extends ValueImpl {
    private String annotationName;
    protected T javaElement;
    private static final String DOT = ".";

    public AnnotationBaseImpl(String annotationName) {
        this.annotationName = annotationName;
    }

    public String getSimpleAnnotationName() {
        int lastDotIndex = this.annotationName.lastIndexOf(DOT);
        if (lastDotIndex == -1) {
            return this.annotationName;
        }
        return this.annotationName.substring(lastDotIndex + 1);
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public void setAppliedElementWithoutSave(T javaElement) {
        this.setJavaElement(javaElement);
    }

    public void setJavaElement(T javaElement) {
        if (javaElement == null) {
            throw new NullPointerException("javaElement should not be null!");
        }
        if (!(javaElement instanceof IType || javaElement instanceof IMethod || javaElement instanceof IField || javaElement instanceof ITypeParameter)) {
            throw new IllegalArgumentException("javaElement is not of correct type!");
        }
        this.javaElement = javaElement;
    }

    public int hashCode() {
        return this.annotationName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationBaseImpl other = (AnnotationBaseImpl)obj;
        return this.annotationName.equals(other.annotationName);
    }
}

