/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.conversion.java;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.EclipseLinkEmbeddedMappingFileWizard;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.EclipseLinkSelectMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java.JavaMetadataConversionWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class EclipseLinkJavaMetadataConversionWizardPage
extends JavaMetadataConversionWizardPage {
    public EclipseLinkJavaMetadataConversionWizardPage(JpaProject jpaProject, String title, String description) {
        super(jpaProject, title, description);
    }

    protected ViewerFilter buildSelectMappingFileDialogViewerFilter() {
        return new XmlMappingFileViewerFilter(this.jpaProject, XmlEntityMappings.CONTENT_TYPE);
    }

    protected IPath openNewMappingFileWizard() {
        return EclipseLinkEmbeddedMappingFileWizard.createNewMappingFile((IStructuredSelection)new StructuredSelection((Object)this.jpaProject.getProject()));
    }

    protected SelectMappingFileDialog buildSelectMappingFileDialog() {
        return new EclipseLinkSelectMappingFileDialog(this.getShell(), this.jpaProject.getProject());
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)this.persistenceUnit;
    }

    protected IPath getDefaultMappingFileRuntimPath() {
        return XmlEntityMappings.DEFAULT_RUNTIME_PATH;
    }

    protected IContentType getMappingFileContentType() {
        return XmlEntityMappings.CONTENT_TYPE;
    }

    protected final boolean isOKToConvert() {
        if (this.hasAnyEquivalentJavaMetadata()) {
            return this.userWantsToContinueWithEquivalentJavaMetadata();
        }
        return super.isOKToConvert();
    }

    protected final boolean hasAnyEquivalentJavaMetadata() {
        return this.persistenceUnit != null && this.hasAnyEquivalentJavaMetadata_();
    }

    protected abstract boolean hasAnyEquivalentJavaMetadata_();

    protected boolean userWantsToContinueWithEquivalentJavaMetadata() {
        if (!OptionalMessageDialog.isDialogEnabled((String)"dontShowEquivalentMetadataExisting.warning")) {
            return true;
        }
        MessageDialog dialog = this.buildEquivalentJavaMetadataWarningDialog();
        return dialog.open() == 2;
    }

    protected MessageDialog buildEquivalentJavaMetadataWarningDialog() {
        return new EquivalentJavaMetadataWarningDialog(this.getShell(), this.getEquivalentJavaMetadataWarningDialogTitle(), this.getEquivalentJavaMetadataWarningDialogMessage());
    }

    protected abstract String getEquivalentJavaMetadataWarningDialogTitle();

    protected abstract String getEquivalentJavaMetadataWarningDialogMessage();

    static class EquivalentJavaMetadataWarningDialog
    extends OptionalMessageDialog {
        static final String ID = "dontShowEquivalentMetadataExisting.warning";

        EquivalentJavaMetadataWarningDialog(Shell parent, String title, String message) {
            super(ID, parent, title, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        }
    }
}

