/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import java.text.MessageFormat;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jst.pagedesigner.editors.SimpleGraphicalEditor;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;

public class DesignerUndoRedoAction
extends Action
implements UpdateAction {
    private boolean _undo = true;
    private final SimpleGraphicalEditor _designer;

    public DesignerUndoRedoAction(boolean undo, SimpleGraphicalEditor designer) {
        this._undo = undo;
        this._designer = designer;
        if (undo) {
            this.setText(ActionsMessages.getString("DesignerUndoRedoAction.UNDO"));
        } else {
            this.setText(ActionsMessages.getString("DesignerUndoRedoAction.REDO"));
        }
    }

    public void update() {
        IStructuredTextUndoManager undoManager = this._designer.getHTMLEditor().getModel().getUndoManager();
        if (this._undo) {
            Command c = undoManager.getUndoCommand();
            this.setEnabled(undoManager.undoable());
            if (c != null) {
                String label = c.getLabel();
                this.setText(MessageFormat.format(ActionsMessages.getString("DesignerUndoRedoAction.UNDO_LABEL"), label));
            } else {
                this.setText(ActionsMessages.getString("DesignerUndoRedoAction.UNDO"));
            }
        } else {
            Command c = undoManager.getRedoCommand();
            this.setEnabled(undoManager.redoable());
            if (c != null) {
                String label = c.getLabel();
                this.setText(MessageFormat.format(ActionsMessages.getString("DesignerUndoRedoAction.REDO_LABEL"), label));
            } else {
                this.setText(ActionsMessages.getString("DesignerUndoRedoAction.REDO"));
            }
        }
    }

    public void run() {
        IStructuredTextUndoManager undoManager = this._designer.getHTMLEditor().getModel().getUndoManager();
        if (this._undo) {
            undoManager.undo((IDocumentSelectionMediator)this._designer);
        } else {
            undoManager.redo((IDocumentSelectionMediator)this._designer);
        }
    }
}

