/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class CreateCompilationUnitTests
extends ModifyingResourceTests {
    public CreateCompilationUnitTests(String name) {
        super(name);
    }

    public static Test suite() {
        return CreateCompilationUnitTests.buildModelTestSuite(CreateCompilationUnitTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createJavaProject("P");
        this.createFolder("/P/p");
        this.startDeltas();
    }

    @Override
    public void tearDown() throws Exception {
        this.stopDeltas();
        this.deleteProject("P");
        super.tearDown();
    }

    public void _testCUAndImportContainer() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.createCompilationUnit("HelloImports.js", "package p;\n\nimport java.util.Enumeration;\nimport java.util.Vector;\n\npublic class HelloImports {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tHelloImports.js[+]: {}");
        IImportDeclaration[] imprts = cu.getImports();
        CreateCompilationUnitTests.assertTrue((String)"Import does not exist", (imprts.length == 2 && imprts[0].exists() ? 1 : 0) != 0);
        cu.close();
        imprts = cu.getImports();
        CreateCompilationUnitTests.assertTrue((String)"Import does not exist", (imprts.length == 2 && imprts[0].exists() ? 1 : 0) != 0);
    }

    public void testDefaultCU() throws CoreException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Default.js");
        IType type = cu.createType("function Default (){this.foo = \"\";}", null, false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertCreation((IJavaScriptElement)type);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tDefault.js[+]: {}\n\nP[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tDefault.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tDefault[+]: {}");
        this.assertElementDescendants("Unexpected children", "Default.js\n  function Default()\n  class Default\n    var foo\n    Default()", (IJavaScriptElement)cu);
        try {
            pkg.createCompilationUnit("Default.js", "", false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Exception status not correct for creating a cu that already exists", (jme.getStatus().getCode() == 977 ? 1 : 0) != 0);
        }
        try {
            pkg.createCompilationUnit("Default.js", "public class Default {}", true, null);
            return;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            CreateCompilationUnitTests.assertTrue((String)"Creation should not fail if the compilation unit already exists", (boolean)false);
            return;
        }
    }

    public void testEmptyCU() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("Empty.js", "", true, null);
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Empty.js");
        this.assertCreation((IJavaScriptElement)cu);
    }

    public void testForce() throws JavaScriptModelException, IOException {
        IPackageFragment pkg = this.getPackage("/P/p");
        File folder = pkg.getResource().getLocation().toFile();
        new File(folder, "X.js").createNewFile();
        IJavaScriptUnit cu = pkg.createCompilationUnit("X.js", "function X() {\n  \"\".toLowerCase();\n}", true, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.js[+]: {}");
    }

    public void testInvalidName() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("HelloWorld.j", null, false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a cu with invalid name", (jme.getStatus().getCode() == 983 ? 1 : 0) != 0);
            try {
                pkg.createCompilationUnit(null, null, false, null);
            }
            catch (JavaScriptModelException jme2) {
                CreateCompilationUnitTests.assertTrue((String)"Incorrect JavaScriptModelException thrown for creating a cu with invalid name", (jme2.getStatus().getCode() == 983 ? 1 : 0) != 0);
                return;
            }
        }
        CreateCompilationUnitTests.assertTrue((String)"No JavaScriptModelException thrown for creating a cu with an invalid name", (boolean)false);
    }

    public void testNullContents() {
        IPackageFragment pkg = this.getPackage("/P/p");
        try {
            pkg.createCompilationUnit("HelloWorld.js", null, false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)("Incorrect JavaScriptModelException thrown for creating a cu with null contents: " + (Object)((Object)jme)), (jme.getStatus().getCode() == 984 ? 1 : 0) != 0);
            return;
        }
        CreateCompilationUnitTests.assertTrue((String)"No JavaScriptModelException thrown for creating a cu with null contents", (boolean)false);
    }

    public void testSimpleCreation() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackage("/P/p");
        IJavaScriptUnit cu = pkg.createCompilationUnit("HelloWorld.js", "function HelloWorld() {\n\n\tthis.main = function(String[] args) {\n\t\t\"HelloWorld\".toLowerCase();\n\t}\n}\n", false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tHelloWorld.js[+]: {}");
    }

    public void testDefaultCUNewFolder() throws CoreException {
        this.createFolder("/P/z");
        IPackageFragment pkg = this.getPackage("/P/z");
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Default.js");
        IType type = cu.createType("function Default2 (){this.foo = \"\";}", null, false, null);
        this.assertCreation((IJavaScriptElement)cu);
        this.assertCreation((IJavaScriptElement)type);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tz[+]: {}\n\nP[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tz[*]: {CHILDREN}\n\t\t\tDefault.js[+]: {}\n\nP[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tz[*]: {CHILDREN}\n\t\t\tDefault.js[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tDefault2[+]: {}");
        this.assertElementDescendants("Unexpected children", "Default.js\n  function Default2()\n  class Default2\n    var foo\n    Default2()", (IJavaScriptElement)cu);
        try {
            pkg.createCompilationUnit("Default.js", "", false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Exception status not correct for creating a cu that already exists", (jme.getStatus().getCode() == 977 ? 1 : 0) != 0);
        }
        try {
            pkg.createCompilationUnit("Default.js", "public class Default {}", true, null);
            return;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            CreateCompilationUnitTests.assertTrue((String)"Creation should not fail if the compilation unit already exists", (boolean)false);
            return;
        }
    }

    public void testDefaultCUNewFolderOperation() throws CoreException {
        IWorkspaceRunnable testRun = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                CreateCompilationUnitTests.this.createFolder("/P/z");
                IPackageFragment pkg = CreateCompilationUnitTests.this.getPackage("/P/z");
                IJavaScriptUnit cu = pkg.getJavaScriptUnit("Default.js");
                IType type = cu.createType("function Default2 (){this.foo = \"\";}", null, false, null);
                CreateCompilationUnitTests.this.assertCreation((IJavaScriptElement)cu);
                CreateCompilationUnitTests.this.assertCreation((IJavaScriptElement)type);
            }
        };
        ResourcesPlugin.getWorkspace().run(testRun, null);
        this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tz[+]: {}");
        IPackageFragment pkg = this.getPackage("/P/z");
        IJavaScriptUnit cu = pkg.getJavaScriptUnit("Default.js");
        this.assertElementDescendants("Unexpected children", "Default.js\n  function Default2()\n  class Default2\n    var foo\n    Default2()", (IJavaScriptElement)cu);
        try {
            pkg.createCompilationUnit("Default.js", "", false, null);
        }
        catch (JavaScriptModelException jme) {
            CreateCompilationUnitTests.assertTrue((String)"Exception status not correct for creating a cu that already exists", (jme.getStatus().getCode() == 977 ? 1 : 0) != 0);
        }
        try {
            pkg.createCompilationUnit("Default.js", "public class Default {}", true, null);
            return;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            CreateCompilationUnitTests.assertTrue((String)"Creation should not fail if the compilation unit already exists", (boolean)false);
            return;
        }
    }
}

