/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.assertions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.testutils.IWaitCondition;
import org.eclipse.jst.ws.jaxws.testutils.assertions.ConditionCheckException;
import org.eclipse.jst.ws.jaxws.testutils.threading.TestContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class Assertions {
    private static final int MAX_CONDITION_CHECKS = 5000;
    private static final int SLEEP_TIMEOUT = 42;

    public static void waitAssert(IWaitCondition condition, String failMessage) {
        try {
            if (!Assertions.waitForConditionLoop(condition)) {
                Assert.fail((String)failMessage);
            }
        }
        catch (ConditionCheckException e) {
            Assertions.failUponThrowable(e);
        }
    }

    private static boolean waitForConditionLoop(IWaitCondition condition) throws ConditionCheckException {
        for (int attempts = 0; attempts < 5000; ++attempts) {
            if (condition.checkCondition()) {
                return true;
            }
            IRunnableWithProgress sleepRunnable = Assertions.getSleepRunnable();
            try {
                TestContext.run(sleepRunnable, Display.getCurrent() != null, (IProgressMonitor)new NullProgressMonitor(), PlatformUI.getWorkbench().getDisplay());
                continue;
            }
            catch (InvocationTargetException e) {
                throw new ConditionCheckException(e);
            }
            catch (InterruptedException e) {
                throw new ConditionCheckException(e);
            }
        }
        return false;
    }

    private static IRunnableWithProgress getSleepRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Thread.sleep(42L);
            }
        };
    }

    private static void failUponThrowable(Throwable t) {
        StringBuilder msgBuilder = new StringBuilder(t.getMessage());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        msgBuilder.append(stringWriter.toString());
        msgBuilder.append("------------------------------------\n\n");
        Assert.fail((String)msgBuilder.toString());
    }
}

