/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionJavadoc;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionOnJavadocTag;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.JavadocTagConstants;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class JavadocCompletionParserTest
extends AbstractCompletionTest
implements JavadocTagConstants {
    public static int INLINE_ALL_TAGS_LENGTH = 0;
    public static int BLOCK_ALL_TAGS_LENGTH = 0;
    CompletionJavadoc javadoc;

    static {
        int i = 0;
        while (i < INLINE_TAGS_LENGTH) {
            INLINE_ALL_TAGS_LENGTH += INLINE_TAGS[i].length;
            ++i;
        }
        i = 0;
        while (i < BLOCK_TAGS_LENGTH) {
            BLOCK_ALL_TAGS_LENGTH += BLOCK_TAGS[i].length;
            ++i;
        }
    }

    public JavadocCompletionParserTest(String testName) {
        super(testName);
    }

    protected void assertCompletionNodeResult(String source, String expected) {
        Expression completionNode = this.javadoc.getCompletionNode();
        JavadocCompletionParserTest.assertNotNull((String)"Javadoc should have a completion node!!!", (Object)completionNode);
        String actual = this.javadoc.getCompletionNode().toString();
        if (!expected.equals(actual)) {
            System.out.println("********************************************************************************");
            System.out.print(this.getName());
            System.out.println(" expect following result:");
            String toDisplay = new String(Util.displayString(new String(actual), 2).toCharArray());
            System.out.println(toDisplay);
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(source);
        }
        JavadocCompletionParserTest.assertEquals("Completion node is not correct!", expected, actual);
    }

    protected void verifyCompletionInJavadoc(String source, String after) {
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit = new CompilationUnit(source.toCharArray(), "Test.java", null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        int cursorLocation = source.indexOf(after) + after.length() - 1;
        parser.dietParse((ICompilationUnit)sourceUnit, compilationResult, cursorLocation);
        JavadocCompletionParserTest.assertNotNull((String)"Parser should have an assist node parent", (Object)parser.assistNodeParent);
        JavadocCompletionParserTest.assertEquals((String)"Expecting completion in javadoc!", CompletionJavadoc.class, parser.assistNodeParent.getClass());
        this.javadoc = (CompletionJavadoc)parser.assistNodeParent;
    }

    protected void verifyCompletionOnJavadocTag(char[] tag, char[][] expectedTags, boolean inline) {
        JavadocCompletionParserTest.assertTrue((String)"Invalid javadoc completion node!", (boolean)(this.javadoc.getCompletionNode() instanceof CompletionOnJavadocTag));
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        StringBuffer expected = new StringBuffer("<CompleteOnJavadocTag:");
        if (inline) {
            expected.append('{');
        }
        expected.append('@');
        if (tag != null) {
            expected.append(tag);
        }
        if (inline) {
            expected.append('}');
        }
        if (expectedTags != null) {
            expected.append("\npossible tags:");
            int length = expectedTags.length;
            int i = 0;
            while (i < length) {
                expected.append("\n\t- ");
                expected.append(expectedTags[i]);
                ++i;
            }
            expected.append('\n');
        }
        expected.append(">");
        if (expectedTags == null) {
            JavadocCompletionParserTest.assertEquals("Invalid completion tag", expected.toString(), completionTag.toString());
        } else {
            String completionTagString = completionTag.toString();
            StringTokenizer completionTagTokenizer = new StringTokenizer(completionTagString, "\n");
            StringBuffer completionTagBuffer = new StringBuffer(completionTagString.length());
            boolean possibleLine = false;
            boolean newLine = false;
            while (completionTagTokenizer.hasMoreTokens()) {
                String line = completionTagTokenizer.nextToken();
                if (line.startsWith("possible")) {
                    if (!possibleLine) {
                        possibleLine = true;
                        completionTagBuffer.append("\npossible tags:");
                    }
                } else {
                    if (newLine) {
                        completionTagBuffer.append('\n');
                    }
                    completionTagBuffer.append(line);
                }
                newLine = true;
            }
            JavadocCompletionParserTest.assertEquals("Invalid completion tag", expected.toString(), completionTagBuffer.toString());
        }
    }

    protected void verifyAllTagsCompletion() {
        char[][] allTags = new char[][]{TAG_AUTHOR, TAG_DEPRECATED, TAG_EXCEPTION, TAG_PARAM, TAG_RETURN, TAG_SEE, TAG_VERSION, TAG_SINCE, TAG_THROWS, TAG_LINK};
        this.verifyCompletionOnJavadocTag(null, allTags, false);
    }

    public void Xtest001() {
        String source = "/**\n * Completion on empty tag name:\n * \t@\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@");
        this.verifyAllTagsCompletion();
    }

    public void test002() {
        String source = "/**\n * Completion on impossible tag name:\n * \t@none\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@none");
        this.verifyCompletionOnJavadocTag("none".toCharArray(), null, false);
    }

    public void test003() {
        String source = "/**\n * Completion on one letter:\n * \t@v\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@v");
        this.verifyCompletionOnJavadocTag(new char[]{'v'}, new char[][]{TAG_VERSION}, false);
    }

    public void test004() {
        String source = "/**\n * Completion with several letters:\n * \t@deprec\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@deprec");
        this.verifyCompletionOnJavadocTag("deprec".toCharArray(), new char[][]{TAG_DEPRECATED}, false);
    }

    public void test005() {
        String source = "/**\n * Completion on full tag name:\n * \t@link\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@link");
        this.verifyCompletionOnJavadocTag("link".toCharArray(), new char[][]{TAG_LINK}, false);
    }

    public void Xtest006() {
        String source = "/**\n * Completion on empty tag name @ but inside text\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@");
        this.verifyCompletionOnJavadocTag(null, new char[][]{TAG_LINK}, false);
    }

    public void Xtest007() {
        String source = "/**\n * Completion on :\n * \t@\n * \t\t- with following lines:\n * \t\t\t+ \"@ {@link }\"\n * \t\t\t+ \"@ {@linkplain }\"\n * \t\t\t+ \"@ {@literal }\"\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@");
        this.verifyAllTagsCompletion();
    }

    public void test010() {
        String source = "/**\n * @see \n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@see ");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:\n\tinfos:formal reference\n>");
    }

    public void test011() {
        String source = "/**\n * {@link }\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@link ");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:\n\tinfos:formal reference\n>");
    }

    public void Xtest012() {
        String source = "/**\n * @see Str\n */\npublic class Test {}\n";
        this.verifyCompletionInJavadoc(source, "Str");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:Str\n\tinfos:formal reference\n>");
    }

    public void test013() {
        String source = "/**\n * {@link Str}\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "Str");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:Str\n\tinfos:formal reference\n>");
    }

    public void test014() {
        String source = "/**\n * @see String Subclass of Obj\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "Obj");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:Obj\n\tinfos:text\n>");
    }

    public void test015() {
        String source = "/**\n * {@link String Subclass of Obj}\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "Obj");
        this.assertCompletionNodeResult(source, "<CompletionOnJavadocSingleTypeReference:Obj\n\tinfos:formal reference\n>");
    }

    public void test021() {
        String source = "/**\n * @see\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@se");
        this.verifyCompletionOnJavadocTag("se".toCharArray(), new char[][]{TAG_SEE}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)7, (int)completionTag.tagSourceStart);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)11, (int)(completionTag.tagSourceEnd + 1));
    }

    public void test022() {
        String source = "/**\n * @see\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "@see");
        this.verifyCompletionOnJavadocTag("see".toCharArray(), new char[][]{TAG_SEE}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)7, (int)completionTag.tagSourceStart);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)11, (int)(completionTag.tagSourceEnd + 1));
    }

    public void test025() {
        String source = "/**\n * {@</code>\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@");
        char[][] allTags = new char[][]{TAG_LINK};
        this.verifyCompletionOnJavadocTag("".toCharArray(), allTags, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf(62);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }

    public void test026() {
        String source = "/**\n * {@li</code>\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@li");
        this.verifyCompletionOnJavadocTag("li".toCharArray(), new char[][]{TAG_LINK}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf(62);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }

    public void test027() {
        String source = "/**\n * {@link</code>\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@link");
        this.verifyCompletionOnJavadocTag("link".toCharArray(), new char[][]{TAG_LINK}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf(62);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }

    public void test028() {
        String source = "/**\n * {@|\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@");
        this.verifyCompletionOnJavadocTag("".toCharArray(), new char[][]{TAG_LINK}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf(124);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }

    public void test029() {
        String source = "/**\n * {@li/\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@li");
        this.verifyCompletionOnJavadocTag("li".toCharArray(), new char[][]{TAG_LINK}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf("/\n");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }

    public void test030() {
        String source = "/**\n * {@link+\n */\nfunction Test() {}\n";
        this.verifyCompletionInJavadoc(source, "{@link");
        this.verifyCompletionOnJavadocTag("link".toCharArray(), new char[][]{TAG_LINK}, false);
        CompletionOnJavadocTag completionTag = (CompletionOnJavadocTag)this.javadoc.getCompletionNode();
        int start = source.indexOf("{@");
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag start position", (int)start, (int)completionTag.tagSourceStart);
        int end = source.indexOf(43);
        JavadocCompletionParserTest.assertEquals((String)"Invalid tag end position", (int)end, (int)completionTag.tagSourceEnd);
    }
}

