/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class CreateCodedReaderTester
extends TestCase {
    private static final String TESTFILES_ZIPFILE_NAME = "testfiles.zip";
    private static final boolean DEBUG = false;
    private static final String TEST_FILE_DIR = "testfiles";
    private static boolean fTestProjectInitialized;
    private static final String TEST_PROJECT_NAME = "org.eclipse.wst.xml.tests.encoding";
    static IProject fTestProject;
    private static int nSetups;
    private static final String currentPlatformCharset;
    private boolean RECREATE_FILES = false;

    static {
        nSetups = 0;
        currentPlatformCharset = CreateCodedReaderTester.getPlatformDefault();
    }

    private static String getPlatformDefault() {
        String platformDefault = NonContentBasedEncodingRules.useDefaultNameRules(null);
        return platformDefault;
    }

    public static void main(String[] args) {
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        CreateCodedReaderTester.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        CreateCodedReaderTester.assertTrue((boolean)fTestProject.exists());
    }

    private void createTestMethodSource(int count, String filePathAndName, String detectedCharsetName, String javaCharsetName, String expectedException) {
        String javaCharsetNameOrKey = javaCharsetName;
        if (javaCharsetNameOrKey != null && javaCharsetNameOrKey.equals(currentPlatformCharset)) {
            javaCharsetNameOrKey = "expectPlatformCharset";
        }
        System.out.println("public void testFile" + count + " () throws CoreException, IOException {" + " doTest( \"" + javaCharsetNameOrKey + "\", \"" + detectedCharsetName + "\",  \"" + filePathAndName + "\", " + expectedException + "); }");
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            CreateCodedReaderTester.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File zipFile = TestsPlugin.getTestFile(TESTFILES_ZIPFILE_NAME);
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(zipFile, destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    public void testCreateAllFiles() throws CoreException, IOException {
        if (this.RECREATE_FILES) {
            List allFiles = TestsPlugin.getAllTestFiles(TEST_FILE_DIR);
            URL outputDirURL = TestsPlugin.getInstallLocation();
            File zipoutFile = new File(outputDirURL.getPath(), TESTFILES_ZIPFILE_NAME);
            FileOutputStream zipOut = new FileOutputStream(zipoutFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(zipOut);
            int count = 1;
            for (File file : allFiles) {
                this.createZipEntry(zipOutputStream, file);
                CodedReaderCreator codedReaderCreator = new CodedReaderCreator();
                codedReaderCreator.set(file.getName(), (InputStream)new FileInputStream(file));
                String detectedCharsetName = null;
                String javaCharsetName = null;
                String expectedException = null;
                try {
                    javaCharsetName = codedReaderCreator.getEncodingMemento().getJavaCharsetName();
                    detectedCharsetName = codedReaderCreator.getEncodingMemento().getDetectedCharsetName();
                }
                catch (UnsupportedCharsetExceptionWithDetail e) {
                    expectedException = String.valueOf(((Object)((Object)e)).getClass().getName()) + ".class";
                }
                catch (MalformedInputException e) {
                    expectedException = String.valueOf(e.getClass().getName()) + ".class";
                }
                catch (IllegalCharsetNameException e) {
                    expectedException = String.valueOf(e.getClass().getName()) + ".class";
                }
                String subpath = this.getSubPathName(file);
                this.createTestMethodSource(count, subpath, detectedCharsetName, javaCharsetName, expectedException);
                ++count;
            }
            zipOutputStream.close();
            zipOut.close();
            CreateCodedReaderTester.assertTrue((boolean)true);
        }
    }

    private String getSubPathName(File file) {
        String path = file.getPath();
        int lastIndex = path.lastIndexOf(TEST_FILE_DIR);
        String subpath = path.substring(lastIndex);
        subpath = subpath.replace('\\', '/');
        return subpath;
    }

    private void createZipEntry(ZipOutputStream zipOutputStream, File file) throws IOException {
        String subPathName = this.getSubPathName(file);
        ZipEntry zipEntry = new ZipEntry(subPathName);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream inputStream = new FileInputStream(file);
        int nRead = 0;
        byte[] buffer = new byte[8192];
        while (nRead != -1) {
            nRead = ((InputStream)inputStream).read(buffer);
            if (nRead <= 0) continue;
            zipOutputStream.write(buffer, 0, nRead);
        }
        zipOutputStream.flush();
    }
}

